/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CppPCHCompileSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualCppPCHSourceFileGeneratorUtil {
    private static SourceFileExtensionCalculator calculator = new SourceFileExtensionCalculator();

    public static <T extends NativeCompileSpec> File generatePCHSourceFile(T original, File sourceFile) {
        File generatedSourceDir = new File(original.getTempDir(), "pchGeneratedSource");
        generatedSourceDir.mkdirs();
        File generatedSource = new File(generatedSourceDir, FilenameUtils.removeExtension((String)sourceFile.getName()).concat(calculator.transform(original.getClass())));
        File headerFileCopy = new File(generatedSourceDir, sourceFile.getName());
        try {
            FileUtils.copyFile((File)sourceFile, (File)headerFileCopy);
            FileUtils.writeStringToFile((File)generatedSource, (String)"#include \"".concat(headerFileCopy.getName()).concat("\""));
            return generatedSource;
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SourceFileExtensionCalculator
    implements Transformer<String, Class<? extends NativeCompileSpec>> {
        SourceFileExtensionCalculator() {
        }

        public String transform(Class<? extends NativeCompileSpec> specClass) {
            if (CPCHCompileSpec.class.isAssignableFrom(specClass)) {
                return ".c";
            }
            if (CppPCHCompileSpec.class.isAssignableFrom(specClass)) {
                return ".cpp";
            }
            throw new GradleException("Cannot determine source file extension for spec with type ".concat(specClass.getSimpleName()));
        }
    }
}

