/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import org.gradle.api.Named;
import org.gradle.nativeplatform.platform.internal.ArchitectureInternal;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.util.VersionNumber;

public class WindowsSdk
implements Named {
    private static final String[] BINPATHS_X86 = new String[]{"bin/x86", "Bin"};
    private static final String[] BINPATHS_AMD64 = new String[]{"bin/x64"};
    private static final String[] BINPATHS_IA64 = new String[]{"bin/IA64"};
    private static final String[] BINPATHS_ARM = new String[]{"bin/arm"};
    private static final String LIBPATH_SDK8 = "Lib/win8/um/";
    private static final String LIBPATH_SDK81 = "Lib/winv6.3/um/";
    private static final String[] LIBPATHS_X86 = new String[]{"Lib/winv6.3/um/x86", "Lib/win8/um/x86", "lib"};
    private static final String[] LIBPATHS_AMD64 = new String[]{"Lib/winv6.3/um/x64", "Lib/win8/um/x64", "lib/x64"};
    private static final String[] LIBPATHS_IA64 = new String[]{"lib/IA64"};
    private static final String[] LIBPATHS_ARM = new String[]{"Lib/winv6.3/um/arm", "Lib/win8/um/arm"};
    private final File baseDir;
    private final VersionNumber version;
    private final String name;

    public WindowsSdk(File baseDir, VersionNumber version, String name) {
        this.baseDir = baseDir;
        this.version = version;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public VersionNumber getVersion() {
        return this.version;
    }

    public File getResourceCompiler(NativePlatformInternal platform) {
        return new File(this.getBinDir(platform), "rc.exe");
    }

    public File getBinDir(NativePlatformInternal platform) {
        if (this.architecture(platform).isAmd64()) {
            return this.getAvailableFile(BINPATHS_AMD64);
        }
        if (this.architecture(platform).isIa64()) {
            return this.getAvailableFile(BINPATHS_IA64);
        }
        if (this.architecture(platform).isArm()) {
            return this.getAvailableFile(BINPATHS_ARM);
        }
        return this.getAvailableFile(BINPATHS_X86);
    }

    public File[] getIncludeDirs() {
        File[] includesSdk8;
        for (File file : includesSdk8 = new File[]{new File(this.baseDir, "Include/shared"), new File(this.baseDir, "Include/um")}) {
            if (file.isDirectory()) continue;
            return new File[]{new File(this.baseDir, "Include")};
        }
        return includesSdk8;
    }

    public File getLibDir(NativePlatformInternal platform) {
        if (this.architecture(platform).isAmd64()) {
            return this.getAvailableFile(LIBPATHS_AMD64);
        }
        if (this.architecture(platform).isIa64()) {
            return this.getAvailableFile(LIBPATHS_IA64);
        }
        if (this.architecture(platform).isArm()) {
            return this.getAvailableFile(LIBPATHS_ARM);
        }
        return this.getAvailableFile(LIBPATHS_X86);
    }

    private ArchitectureInternal architecture(NativePlatformInternal platform) {
        return platform.getArchitecture();
    }

    private File getAvailableFile(String ... candidates) {
        for (String candidate : candidates) {
            File file = new File(this.baseDir, candidate);
            if (!file.isDirectory()) continue;
            return file;
        }
        return new File(this.baseDir, candidates[0]);
    }
}

