/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.JavaVersion;
import org.gradle.api.Nullable;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.jvm.JavaHomeException;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.Jre;
import org.gradle.internal.os.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jvm
implements JavaInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jvm.class);
    private final OperatingSystem os;
    private final File javaBase;
    private final File javaHome;
    private final boolean userSupplied;
    private final JavaVersion javaVersion;
    private static final AtomicReference<Jvm> CURRENT = new AtomicReference();

    public static Jvm current() {
        Jvm jvm = CURRENT.get();
        if (jvm == null) {
            CURRENT.compareAndSet(null, Jvm.create(null));
            jvm = CURRENT.get();
        }
        return jvm;
    }

    static Jvm create(File javaBase) {
        String vendor = System.getProperty("java.vm.vendor");
        if (vendor.toLowerCase().startsWith("apple inc.")) {
            return new AppleJvm(OperatingSystem.current(), javaBase);
        }
        if (vendor.toLowerCase().startsWith("ibm corporation")) {
            return new IbmJvm(OperatingSystem.current(), javaBase);
        }
        return new Jvm(OperatingSystem.current(), javaBase);
    }

    Jvm(OperatingSystem os) {
        this(os, null);
    }

    Jvm(OperatingSystem os, File suppliedJavaBase) {
        this.os = os;
        if (suppliedJavaBase == null) {
            try {
                this.javaBase = new File(System.getProperty("java.home")).getCanonicalFile();
            }
            catch (IOException e) {
                throw new UncheckedException(e);
            }
            this.javaHome = this.findJavaHome(this.javaBase);
            this.javaVersion = JavaVersion.current();
            this.userSupplied = false;
        } else {
            this.javaBase = suppliedJavaBase;
            this.javaHome = suppliedJavaBase;
            this.userSupplied = true;
            this.javaVersion = null;
        }
    }

    public static JavaInfo forHome(File javaHome) throws JavaHomeException, IllegalArgumentException {
        if (javaHome == null || !javaHome.isDirectory()) {
            throw new IllegalArgumentException("Supplied javaHome must be a valid directory. You supplied: " + javaHome);
        }
        Jvm jvm = Jvm.create(javaHome);
        jvm.getJavaExecutable();
        return jvm;
    }

    public String toString() {
        if (this.userSupplied) {
            return "User-supplied java: " + this.javaBase;
        }
        return String.format("%s (%s %s)", SystemProperties.getJavaVersion(), System.getProperty("java.vm.vendor"), System.getProperty("java.vm.version"));
    }

    private File findExecutable(String command) {
        File exec = new File(this.getJavaHome(), "bin/" + command);
        File executable = new File(this.os.getExecutableName(exec.getAbsolutePath()));
        if (executable.isFile()) {
            return executable;
        }
        if (this.userSupplied) {
            throw new JavaHomeException(String.format("The supplied javaHome seems to be invalid. I cannot find the %s executable. Tried location: %s", command, executable.getAbsolutePath()));
        }
        File pathExecutable = this.os.findInPath(command);
        if (pathExecutable != null) {
            LOGGER.info(String.format("Unable to find the '%s' executable using home: %s. We found it on the PATH: %s.", command, this.getJavaHome(), pathExecutable));
            return pathExecutable;
        }
        LOGGER.warn("Unable to find the '{}' executable. Tried the java home: {} and the PATH. We will assume the executable can be ran in the current working folder.", (Object)command, (Object)this.getJavaHome());
        return new File(this.os.getExecutableName(command));
    }

    @Override
    public File getJavaExecutable() throws JavaHomeException {
        return this.findExecutable("java");
    }

    public File getJavacExecutable() throws JavaHomeException {
        return this.findExecutable("javac");
    }

    @Override
    public File getJavadocExecutable() throws JavaHomeException {
        return this.findExecutable("javadoc");
    }

    @Override
    public File getExecutable(String name) throws JavaHomeException {
        return this.findExecutable(name);
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    @Override
    public File getJavaHome() {
        return this.javaHome;
    }

    private File findJavaHome(File javaBase) {
        File toolsJar = this.findToolsJar(javaBase);
        if (toolsJar != null) {
            return toolsJar.getParentFile().getParentFile();
        }
        if (javaBase.getName().equalsIgnoreCase("jre") && new File(javaBase.getParentFile(), "bin/java").exists()) {
            return javaBase.getParentFile();
        }
        return javaBase;
    }

    @Override
    public File getRuntimeJar() {
        File runtimeJar = new File(this.javaBase, "lib/rt.jar");
        if (runtimeJar.exists()) {
            return runtimeJar;
        }
        runtimeJar = new File(this.javaBase, "jre/lib/rt.jar");
        return runtimeJar.exists() ? runtimeJar : null;
    }

    @Override
    public File getToolsJar() {
        return this.findToolsJar(this.javaBase);
    }

    @Nullable
    public Jre getStandaloneJre() {
        File jreDir;
        if (this.os.isWindows() && (jreDir = this.javaVersion.isJava5() ? new File(this.javaHome.getParentFile(), String.format("jre%s", SystemProperties.getJavaVersion())) : new File(this.javaHome.getParentFile(), String.format("jre%s", this.javaVersion.getMajorVersion()))).isDirectory()) {
            return new DefaultJre(jreDir);
        }
        if (!new File(this.javaHome, "jre").isDirectory()) {
            return new DefaultJre(this.javaHome);
        }
        return null;
    }

    public Jre getJre() {
        File jreDir = new File(this.javaBase, "jre");
        if (jreDir.isDirectory()) {
            return new DefaultJre(jreDir);
        }
        return new DefaultJre(this.javaBase);
    }

    private File findToolsJar(File javaHome) {
        File toolsJar = new File(javaHome, "lib/tools.jar");
        if (toolsJar.exists()) {
            return toolsJar;
        }
        if (javaHome.getName().equalsIgnoreCase("jre") && (toolsJar = new File(javaHome = javaHome.getParentFile(), "lib/tools.jar")).exists()) {
            return toolsJar;
        }
        if (this.os.isWindows()) {
            String version = SystemProperties.getJavaVersion();
            if ((javaHome.getName().matches("jre\\d+") || javaHome.getName().equals(String.format("jre%s", version))) && (toolsJar = new File(javaHome = new File(javaHome.getParentFile(), String.format("jdk%s", version)), "lib/tools.jar")).exists()) {
                return toolsJar;
            }
        }
        return null;
    }

    public Map<String, ?> getInheritableEnvironmentVariables(Map<String, ?> envVars) {
        return envVars;
    }

    public boolean isIbmJvm() {
        return false;
    }

    private static class DefaultJre
    extends Jre {
        private final File jreDir;

        public DefaultJre(File jreDir) {
            this.jreDir = jreDir;
        }

        public File getHomeDir() {
            return this.jreDir;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AppleJvm
    extends Jvm {
        AppleJvm(OperatingSystem os) {
            super(os);
        }

        AppleJvm(OperatingSystem current, File javaHome) {
            super(current, javaHome);
        }

        @Override
        public File getRuntimeJar() {
            File javaHome = super.getJavaHome();
            File runtimeJar = new File(javaHome.getParentFile(), "Classes/classes.jar");
            return runtimeJar.exists() ? runtimeJar : null;
        }

        @Override
        public File getToolsJar() {
            return this.getRuntimeJar();
        }

        @Override
        public Map<String, ?> getInheritableEnvironmentVariables(Map<String, ?> envVars) {
            HashMap vars = new HashMap();
            for (Map.Entry<String, ?> entry : envVars.entrySet()) {
                if (entry.getKey().matches("APP_NAME_\\d+") || entry.getKey().matches("JAVA_MAIN_CLASS_\\d+")) continue;
                vars.put(entry.getKey(), entry.getValue());
            }
            return vars;
        }
    }

    static class IbmJvm
    extends Jvm {
        IbmJvm(OperatingSystem os, File suppliedJavaBase) {
            super(os, suppliedJavaBase);
        }

        public boolean isIbmJvm() {
            return true;
        }
    }
}

