/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.model.MavenArtifact;

public class DependencyConflictId {
    private final String groupId;
    private final String artifactId;
    private final String type;
    private final String classifier;

    public DependencyConflictId(String groupId, String artifactId, String type, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.type = StringUtil.isEmpty((String)type) ? "jar" : type;
        this.classifier = classifier;
    }

    public static DependencyConflictId create(MavenDomDependency dep) {
        String groupId = dep.getGroupId().getStringValue();
        if (StringUtil.isEmpty((String)groupId)) {
            return null;
        }
        String artifactId = dep.getArtifactId().getStringValue();
        if (StringUtil.isEmpty((String)artifactId)) {
            return null;
        }
        return new DependencyConflictId(groupId, artifactId, dep.getType().getStringValue(), dep.getClassifier().getStringValue());
    }

    public static DependencyConflictId create(MavenArtifact dep) {
        return DependencyConflictId.create(dep.getGroupId(), dep.getArtifactId(), dep.getType(), dep.getClassifier());
    }

    public static DependencyConflictId create(String groupId, String artifactId, String type, String classifier) {
        if (StringUtil.isEmpty((String)groupId)) {
            return null;
        }
        if (StringUtil.isEmpty((String)artifactId)) {
            return null;
        }
        return new DependencyConflictId(groupId, artifactId, type, classifier);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DependencyConflictId)) {
            return false;
        }
        DependencyConflictId id = (DependencyConflictId)o;
        if (!this.artifactId.equals(id.artifactId)) {
            return false;
        }
        if (this.classifier != null ? !this.classifier.equals(id.classifier) : id.classifier != null) {
            return false;
        }
        if (!this.groupId.equals(id.groupId)) {
            return false;
        }
        return this.type.equals(id.type);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        return result;
    }
}

