/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.DomElement;
import java.io.File;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.plugin.MavenDomPluginModel;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;

public class MavenPluginDomUtil {
    public static MavenDomPluginModel getMavenPluginModel(DomElement element) {
        Project project = element.getManager().getProject();
        MavenDomPlugin pluginElement = (MavenDomPlugin)element.getParentOfType(MavenDomPlugin.class, false);
        if (pluginElement == null) {
            return null;
        }
        String groupId = pluginElement.getGroupId().getStringValue();
        String artifactId = pluginElement.getArtifactId().getStringValue();
        String version = pluginElement.getVersion().getStringValue();
        return MavenPluginDomUtil.getMavenPluginModel(project, groupId, artifactId, version);
    }

    public static MavenDomPluginModel getMavenPluginModel(Project project, String groupId, String artifactId, String version) {
        VirtualFile pluginXmlFile = MavenPluginDomUtil.getPluginXmlFile(project, groupId, artifactId, version);
        if (pluginXmlFile == null) {
            return null;
        }
        return MavenDomUtil.getMavenDomModel(project, pluginXmlFile, MavenDomPluginModel.class);
    }

    public static boolean isPlugin(MavenDomConfiguration configuration, String groupId, String artifactId) {
        MavenDomPlugin domPlugin = (MavenDomPlugin)configuration.getParentOfType(MavenDomPlugin.class, true);
        if (domPlugin == null) {
            return false;
        }
        return MavenPluginDomUtil.isPlugin(domPlugin, groupId, artifactId);
    }

    public static boolean isPlugin(MavenDomPlugin plugin, String groupId, String artifactId) {
        if (!artifactId.equals(plugin.getArtifactId().getStringValue())) {
            return false;
        }
        String pluginGroupId = plugin.getGroupId().getStringValue();
        if (groupId == null) {
            return pluginGroupId == null || pluginGroupId.equals("org.apache.maven.plugins") || pluginGroupId.equals("org.codehaus.mojo");
        }
        if (pluginGroupId == null && (groupId.equals("org.apache.maven.plugins") || groupId.equals("org.codehaus.mojo"))) {
            return true;
        }
        return groupId.equals(pluginGroupId);
    }

    private static VirtualFile getPluginXmlFile(Project project, String groupId, String artifactId, String version) {
        File file = MavenArtifactUtil.getArtifactFile(MavenProjectsManager.getInstance(project).getLocalRepository(), groupId, artifactId, version, "jar");
        VirtualFile pluginFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (pluginFile == null) {
            return null;
        }
        VirtualFile pluginJarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(pluginFile);
        if (pluginJarRoot == null) {
            return null;
        }
        return pluginJarRoot.findFileByRelativePath("META-INF/maven/plugin.xml");
    }
}

