/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;

public abstract class MavenConstantListConverter
extends ResolvingConverter<String> {
    private boolean myStrict;

    protected MavenConstantListConverter() {
        this(true);
    }

    protected MavenConstantListConverter(boolean strict) {
        this.myStrict = strict;
    }

    public String fromString(@NonNls String s, ConvertContext context) {
        if (!this.myStrict) {
            return s;
        }
        return this.getValues(context).contains(s) ? s : null;
    }

    public String toString(String s, ConvertContext context) {
        return s;
    }

    public Collection<String> getVariants(ConvertContext context) {
        return this.getValues(context);
    }

    protected abstract Collection<String> getValues(ConvertContext var1);

    public String getErrorMessage(String s, ConvertContext context) {
        return "<html>Specified value is not acceptable here.<br>Acceptable values: " + StringUtil.join(this.getValues(context), (String)", ") + "</html>";
    }
}

