/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesHelper;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.references.MavenPathReferenceConverter;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenParentRelativePathConverter
extends ResolvingConverter<PsiFile>
implements CustomReferenceConverter {
    public PsiFile fromString(@NonNls String s, ConvertContext context) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return null;
        }
        VirtualFile contextFile = context.getFile().getVirtualFile();
        if (contextFile == null) {
            return null;
        }
        VirtualFile f = contextFile.getParent().findFileByRelativePath(s);
        if (f == null) {
            return null;
        }
        if (f.isDirectory()) {
            f = f.findChild("pom.xml");
        }
        if (f == null) {
            return null;
        }
        return context.getPsiManager().findFile(f);
    }

    public String toString(PsiFile f, ConvertContext context) {
        if (f == null) {
            return null;
        }
        VirtualFile currentFile = context.getFile().getOriginalFile().getVirtualFile();
        if (currentFile == null) {
            return null;
        }
        return MavenDomUtil.calcRelativePath(currentFile.getParent(), f.getVirtualFile());
    }

    public Collection<PsiFile> getVariants(ConvertContext context) {
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        PsiFile currentFile = context.getFile().getOriginalFile();
        for (DomFileElement<MavenDomProjectModel> each : MavenDomUtil.collectProjectModels(context.getFile().getProject())) {
            XmlFile file = each.getOriginalFile();
            if (file == currentFile) continue;
            result.add((PsiFile)file);
        }
        return result;
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        return (LocalQuickFix[])ArrayUtil.append((Object[])super.getQuickFixes(context), (Object)new RelativePathFix(context));
    }

    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        return new MavenPathReferenceConverter(new Condition<PsiFileSystemItem>(){

            public boolean value(PsiFileSystemItem item) {
                return item.isDirectory() || item.getName().equals("pom.xml");
            }
        }).createReferences(genericDomValue, element, context);
    }

    private static class RelativePathFix
    implements LocalQuickFix {
        private final ConvertContext myContext;

        public RelativePathFix(ConvertContext context) {
            this.myContext = context;
        }

        public String getName() {
            return MavenDomBundle.message("fix.parent.path", new Object[0]);
        }

        public String getFamilyName() {
            return MavenDomBundle.message("inspection.group", new Object[0]);
        }

        public void applyFix(Project project, ProblemDescriptor descriptor) {
            GenericDomValue el = (GenericDomValue)this.myContext.getInvocationElement();
            MavenId id = MavenArtifactCoordinatesHelper.getId(this.myContext);
            MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
            MavenProject parentFile = manager.findProject(id);
            if (parentFile != null) {
                VirtualFile currentFile = this.myContext.getFile().getVirtualFile();
                el.setStringValue(MavenDomUtil.calcRelativePath(currentFile.getParent(), parentFile.getFile()));
            }
        }
    }
}

