/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.psi.PsiElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.maven.dom.MavenPluginDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenDomSoftAwareConverter;
import org.jetbrains.idea.maven.dom.plugin.MavenDomMojo;
import org.jetbrains.idea.maven.dom.plugin.MavenDomPluginModel;

public class MavenPluginGoalConverter
extends ResolvingConverter<String>
implements MavenDomSoftAwareConverter {
    public String fromString(@NonNls String s, ConvertContext context) {
        return this.getVariants(context).contains(s) ? s : null;
    }

    public String toString(String s, ConvertContext context) {
        return s;
    }

    public Collection<String> getVariants(ConvertContext context) {
        MavenDomPluginModel model = MavenPluginDomUtil.getMavenPluginModel(context.getInvocationElement());
        if (model == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (MavenDomMojo each : model.getMojos().getMojos()) {
            String goal = each.getGoal().getStringValue();
            if (goal == null) continue;
            result.add(goal);
        }
        return result;
    }

    public PsiElement resolve(String text, ConvertContext context) {
        MavenDomPluginModel model = MavenPluginDomUtil.getMavenPluginModel(context.getInvocationElement());
        if (model == null) {
            return null;
        }
        for (MavenDomMojo each : model.getMojos().getMojos()) {
            String goal = each.getGoal().getStringValue();
            if (!text.equals(goal)) continue;
            return each.getXmlElement();
        }
        return super.resolve((Object)text, context);
    }

    @Override
    public boolean isSoft(DomElement element) {
        return MavenPluginDomUtil.getMavenPluginModel(element) == null;
    }
}

