/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters.repositories;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import icons.MavenIcons;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.maven.dom.converters.MavenUrlConverter;
import org.jetbrains.idea.maven.dom.converters.repositories.MavenRepositoriesProvider;
import org.jetbrains.idea.maven.dom.model.MavenDomRepositoryBase;

public abstract class MavenRepositoryConverter
extends ResolvingConverter<String> {
    private static String getRepositoryId(ConvertContext context) {
        MavenDomRepositoryBase repository = (MavenDomRepositoryBase)context.getInvocationElement().getParentOfType(MavenDomRepositoryBase.class, false);
        if (repository != null) {
            return repository.getId().getStringValue();
        }
        return null;
    }

    public String fromString(@NonNls String s, ConvertContext context) {
        return s;
    }

    public String toString(String s, ConvertContext convertContext) {
        return s;
    }

    public static class Url
    extends MavenUrlConverter {
        @Override
        public PsiReference[] createReferences(GenericDomValue value, PsiElement element, final ConvertContext context) {
            return new PsiReference[]{new WebReference(element){

                public Object[] getVariants() {
                    String name;
                    Module module = context.getModule();
                    if (module != null && !StringUtil.isEmptyOrSpaces((String)(name = MavenRepositoriesProvider.getInstance().getRepositoryUrl(MavenRepositoryConverter.getRepositoryId(context))))) {
                        return new Object[]{name};
                    }
                    return super.getVariants();
                }
            }};
        }
    }

    public static class Name
    extends MavenRepositoryConverter {
        public Collection<String> getVariants(ConvertContext context) {
            String name;
            Module module = context.getModule();
            if (module != null && !StringUtil.isEmptyOrSpaces((String)(name = MavenRepositoriesProvider.getInstance().getRepositoryName(MavenRepositoryConverter.getRepositoryId(context))))) {
                return Collections.singleton(name);
            }
            return Collections.emptySet();
        }
    }

    public static class Id
    extends MavenRepositoryConverter {
        public Collection<String> getVariants(ConvertContext context) {
            Module module = context.getModule();
            if (module != null) {
                return MavenRepositoriesProvider.getInstance().getRepositoryIds();
            }
            return Collections.emptySet();
        }

        public LookupElement createLookupElement(String s) {
            return LookupElementBuilder.create((String)s).withIcon(MavenIcons.MavenPlugin).withTailText(" (" + MavenRepositoriesProvider.getInstance().getRepositoryUrl(s) + ")", true);
        }
    }
}

