/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenDuplicateDependenciesInspection
extends DomElementsInspection<MavenDomProjectModel> {
    public MavenDuplicateDependenciesInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<MavenDomProjectModel> domFileElement, DomElementAnnotationHolder holder) {
        MavenDomProjectModel projectModel = (MavenDomProjectModel)domFileElement.getRootElement();
        MavenDuplicateDependenciesInspection.checkManagedDependencies(projectModel, holder);
        MavenDuplicateDependenciesInspection.checkDependencies(projectModel, holder);
    }

    private static void checkDependencies(MavenDomProjectModel projectModel, DomElementAnnotationHolder holder) {
        MultiMap<DependencyConflictId, MavenDomDependency> allDuplicates = MavenDuplicateDependenciesInspection.getDuplicateDependenciesMap(projectModel);
        for (MavenDomDependency dependency : projectModel.getDependencies().getDependencies()) {
            Collection dependencies;
            DependencyConflictId id = DependencyConflictId.create(dependency);
            if (id == null || (dependencies = allDuplicates.get((Object)id)).size() <= 1) continue;
            ArrayList<MavenDomDependency> duplicatedDependencies = new ArrayList<MavenDomDependency>();
            for (MavenDomDependency d : dependencies) {
                if (d == dependency) continue;
                if (d.getParent() == dependency.getParent()) {
                    duplicatedDependencies.add(d);
                    continue;
                }
                if (!MavenDuplicateDependenciesInspection.scope(d).equals(MavenDuplicateDependenciesInspection.scope(dependency)) || !Comparing.equal((String)d.getVersion().getStringValue(), (String)dependency.getVersion().getStringValue())) continue;
                duplicatedDependencies.add(d);
            }
            if (duplicatedDependencies.size() <= 0) continue;
            MavenDuplicateDependenciesInspection.addProblem(dependency, duplicatedDependencies, holder);
        }
    }

    private static String scope(MavenDomDependency dependency) {
        String res = dependency.getScope().getRawText();
        if (StringUtil.isEmpty((String)res)) {
            return "compile";
        }
        return res;
    }

    private static void addProblem(MavenDomDependency dependency, Collection<MavenDomDependency> dependencies, DomElementAnnotationHolder holder) {
        StringBuilder sb = new StringBuilder();
        HashSet processed = new HashSet();
        for (MavenDomDependency domDependency : dependencies) {
            MavenDomProjectModel model;
            if (dependency.equals(domDependency) || (model = (MavenDomProjectModel)domDependency.getParentOfType(MavenDomProjectModel.class, false)) == null || processed.contains(model)) continue;
            if (processed.size() > 0) {
                sb.append(", ");
            }
            sb.append(MavenDuplicateDependenciesInspection.createLinkText(model, domDependency));
            processed.add(model);
        }
        holder.createProblem((DomElement)dependency, HighlightSeverity.WARNING, MavenDomBundle.message("MavenDuplicateDependenciesInspection.has.duplicates", sb.toString()));
    }

    private static String createLinkText(MavenDomProjectModel model, MavenDomDependency dependency) {
        XmlTag tag = dependency.getXmlTag();
        if (tag == null) {
            return MavenDuplicateDependenciesInspection.getProjectName(model);
        }
        VirtualFile file = tag.getContainingFile().getVirtualFile();
        if (file == null) {
            return MavenDuplicateDependenciesInspection.getProjectName(model);
        }
        return "<a href ='#navigation/" + file.getPath() + ":" + tag.getTextRange().getStartOffset() + "'>" + MavenDuplicateDependenciesInspection.getProjectName(model) + "</a>";
    }

    private static String getProjectName(MavenDomProjectModel model) {
        MavenProject mavenProject = MavenDomUtil.findProject(model);
        if (mavenProject != null) {
            return mavenProject.getDisplayName();
        }
        String name = model.getName().getStringValue();
        if (!StringUtil.isEmptyOrSpaces((String)name)) {
            return name;
        }
        return "pom.xml";
    }

    private static MultiMap<DependencyConflictId, MavenDomDependency> getDuplicateDependenciesMap(MavenDomProjectModel projectModel) {
        final MultiMap allDependencies = MultiMap.createSet();
        Processor<MavenDomProjectModel> collectProcessor = new Processor<MavenDomProjectModel>(){

            public boolean process(MavenDomProjectModel model) {
                MavenDuplicateDependenciesInspection.collect((MultiMap<DependencyConflictId, MavenDomDependency>)allDependencies, model.getDependencies());
                return false;
            }
        };
        MavenDomProjectProcessorUtils.processChildrenRecursively(projectModel, collectProcessor, true);
        MavenDomProjectProcessorUtils.processParentProjects(projectModel, collectProcessor);
        return allDependencies;
    }

    private static void collect(MultiMap<DependencyConflictId, MavenDomDependency> duplicates, MavenDomDependencies dependencies) {
        for (MavenDomDependency dependency : dependencies.getDependencies()) {
            DependencyConflictId mavenId = DependencyConflictId.create(dependency);
            if (mavenId == null) continue;
            duplicates.putValue((Object)mavenId, (Object)dependency);
        }
    }

    private static void checkManagedDependencies(MavenDomProjectModel projectModel, DomElementAnnotationHolder holder) {
        MultiMap duplicates = MultiMap.createSet();
        MavenDuplicateDependenciesInspection.collect((MultiMap<DependencyConflictId, MavenDomDependency>)duplicates, projectModel.getDependencyManagement().getDependencies());
        for (Map.Entry entry : duplicates.entrySet()) {
            Collection set = (Collection)entry.getValue();
            if (set.size() <= 1) continue;
            for (MavenDomDependency dependency : set) {
                holder.createProblem((DomElement)dependency, HighlightSeverity.WARNING, "Duplicated dependency");
            }
        }
    }

    public String getGroupDisplayName() {
        return MavenDomBundle.message("inspection.group", new Object[0]);
    }

    public String getDisplayName() {
        return MavenDomBundle.message("inspection.duplicate.dependencies.name", new Object[0]);
    }

    public String getShortName() {
        return "MavenDuplicateDependenciesInspection";
    }

    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.WARNING;
    }
}

