/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;

public class MavenContextlessPropertyReference
extends PsiReferenceBase<PsiElement> {
    private final XmlTag myProperties;

    public MavenContextlessPropertyReference(XmlTag properties, PsiElement element, TextRange range, boolean isSoft) {
        super(element, range, isSoft);
        this.myProperties = properties;
    }

    public PsiElement resolve() {
        String value = this.getValue();
        for (XmlTag subTag : this.myProperties.getSubTags()) {
            if (!value.equals(subTag.getName())) continue;
            return subTag;
        }
        return null;
    }

    public Object[] getVariants() {
        String skippedPropertyName = null;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlTag.class, (boolean)false);
        if (xmlTag != null && this.myProperties == xmlTag.getParentTag()) {
            skippedPropertyName = xmlTag.getName();
        }
        ArrayList<String> res = new ArrayList<String>();
        for (XmlTag subTag : this.myProperties.getSubTags()) {
            String name = subTag.getName();
            if (name.equals(skippedPropertyName)) continue;
            res.add(name);
        }
        return res.toArray();
    }
}

