/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.PathUtil;
import com.intellij.util.xml.DomFileElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.references.MavenPsiReference;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenModulePsiReference
extends MavenPsiReference
implements LocalQuickFixProvider {
    public MavenModulePsiReference(PsiElement element, String text, TextRange range) {
        super(element, text, range);
    }

    public PsiElement resolve() {
        String relPath;
        VirtualFile baseDir = this.myPsiFile.getVirtualFile().getParent();
        VirtualFile file = baseDir.findFileByRelativePath(relPath = FileUtil.toSystemIndependentName((String)(this.myText + "/" + "pom.xml")));
        if (file == null) {
            return null;
        }
        return this.getPsiFile(file);
    }

    public Object[] getVariants() {
        List<DomFileElement<MavenDomProjectModel>> files = MavenDomUtil.collectProjectModels(this.getProject());
        ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>();
        for (DomFileElement<MavenDomProjectModel> eachDomFile : files) {
            VirtualFile eachVFile = eachDomFile.getOriginalFile().getVirtualFile();
            if (Comparing.equal((Object)eachVFile, (Object)this.myVirtualFile)) continue;
            XmlFile psiFile = eachDomFile.getFile();
            String modulePath = MavenModulePsiReference.calcRelativeModulePath(this.myVirtualFile, eachVFile);
            result.add(LookupElementBuilder.create((Object)psiFile, (String)modulePath).withPresentableText(modulePath));
        }
        return result.toArray();
    }

    public static String calcRelativeModulePath(VirtualFile parentPom, VirtualFile modulePom) {
        String result = MavenDomUtil.calcRelativePath(parentPom.getParent(), modulePom);
        int to = result.length() - "/pom.xml".length();
        if (to < 0) {
            throw new RuntimeException("Filed to calculate relative path for:\nparentPom: " + parentPom + "(valid: " + parentPom.isValid() + ")" + "\nmodulePom: " + modulePom + "(valid: " + modulePom.isValid() + ")" + "\nequals:" + parentPom.equals(modulePom));
        }
        return result.substring(0, to);
    }

    private PsiFile getPsiFile(VirtualFile file) {
        return PsiManager.getInstance((Project)this.getProject()).findFile(file);
    }

    private Project getProject() {
        return this.myPsiFile.getProject();
    }

    public LocalQuickFix[] getQuickFixes() {
        if (this.myText.length() == 0 || this.resolve() != null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{new CreateModuleFix(true), new CreateModuleFix(false)};
    }

    private class CreateModuleFix
    implements LocalQuickFix {
        private final boolean myWithParent;

        private CreateModuleFix(boolean withParent) {
            this.myWithParent = withParent;
        }

        public String getName() {
            return this.myWithParent ? MavenDomBundle.message("fix.create.module.with.parent", new Object[0]) : MavenDomBundle.message("fix.create.module", new Object[0]);
        }

        public String getFamilyName() {
            return MavenDomBundle.message("inspection.group", new Object[0]);
        }

        public void applyFix(Project project, ProblemDescriptor d) {
            try {
                VirtualFile modulePom = this.createModulePom();
                MavenId id = MavenDomUtil.describe(MavenModulePsiReference.this.myPsiFile);
                String groupId = id.getGroupId() == null ? "groupId" : id.getGroupId();
                String artifactId = modulePom.getParent().getName();
                String version = id.getVersion() == null ? "version" : id.getVersion();
                MavenUtil.runOrApplyMavenProjectFileTemplate(project, modulePom, new MavenId(groupId, artifactId, version), (MavenId)(this.myWithParent ? id : null), MavenModulePsiReference.this.myPsiFile.getVirtualFile(), true);
            }
            catch (IOException e) {
                MavenUtil.showError(project, "Cannot create a module", e);
            }
        }

        private VirtualFile createModulePom() throws IOException {
            VirtualFile baseDir = MavenModulePsiReference.this.myVirtualFile.getParent();
            String modulePath = PathUtil.getCanonicalPath((String)(baseDir.getPath() + "/" + MavenModulePsiReference.this.myText));
            VirtualFile moduleDir = VfsUtil.createDirectories((String)modulePath);
            return moduleDir.createChildData((Object)this, "pom.xml");
        }
    }
}

