/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.references.MavenFilteredPropertyPsiReference;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenPropertyCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(CompletionParameters parameters, CompletionResultSet result) {
        int offset;
        PsiFile psiFile = parameters.getOriginalFile();
        Project project = psiFile.getProject();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        if (!manager.isMavenizedProject()) {
            return;
        }
        MavenProject projectFile = MavenDomUtil.findContainingProject((PsiElement)psiFile);
        if (projectFile == null) {
            return;
        }
        if (!MavenDomUtil.isMavenFile(psiFile) && !MavenDomUtil.isFilteredResourceFile((PsiElement)psiFile)) {
            return;
        }
        String text = psiFile.getText();
        int braceOffset = MavenPropertyCompletionContributor.findOpenBrace(text, offset = parameters.getOffset());
        if (braceOffset == -1) {
            return;
        }
        TextRange range = TextRange.create((int)braceOffset, (int)offset);
        String prefix = range.substring(text);
        MavenFilteredPropertyPsiReference ref = new MavenFilteredPropertyPsiReference(projectFile, (PsiElement)psiFile, prefix, range);
        MavenPropertyCompletionContributor.addVariants(Arrays.asList(ref.getVariants()), result.withPrefixMatcher(prefix));
    }

    public static void addVariants(Collection<?> variants, CompletionResultSet result) {
        for (Object each : variants) {
            Object e = each instanceof LookupElement ? (LookupElement)each : (each instanceof String ? LookupElementBuilder.create((String)((String)each)) : (each instanceof PsiNamedElement ? LookupElementBuilder.create((PsiNamedElement)((PsiNamedElement)each)) : LookupElementBuilder.create(each, (String)String.valueOf(each))));
            result.addElement(e);
        }
    }

    private static int findOpenBrace(CharSequence text, int offset) {
        for (int i = offset - 1; i > 0; --i) {
            char c = text.charAt(i);
            if (c == '{' && text.charAt(i - 1) == '$') {
                return i + 1;
            }
            if (Character.isLetterOrDigit(c) || c == '.') continue;
            return -1;
        }
        return -1;
    }
}

