/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.text.MessageFormat;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenConsole;

public abstract class MavenExecutor {
    final MavenRunnerParameters myParameters;
    private final String myCaption;
    protected MavenConsole myConsole;
    private String myAction;
    private boolean stopped = true;
    private boolean cancelled = false;
    private int exitCode = 0;

    public MavenExecutor(MavenRunnerParameters parameters, String caption, MavenConsole console) {
        this.myParameters = parameters;
        this.myCaption = caption;
        this.myConsole = console;
    }

    public String getCaption() {
        return this.myCaption;
    }

    public MavenConsole getConsole() {
        return this.myConsole;
    }

    public void setAction(String action) {
        this.myAction = action;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    void start() {
        this.stopped = false;
    }

    void stop() {
        this.stopped = true;
        this.myConsole.setOutputPaused(false);
    }

    boolean isCancelled() {
        return this.cancelled;
    }

    public void cancel() {
        this.cancelled = true;
        this.stop();
    }

    protected void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    void displayProgress() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(MessageFormat.format("{0} {1}", this.myAction != null ? this.myAction : RunnerBundle.message("maven.running", new Object[0]), this.myParameters.getWorkingDirPath()));
            indicator.setText2(this.myParameters.getGoals().toString());
        }
    }

    protected boolean printExitSummary() {
        if (this.isCancelled()) {
            this.myConsole.systemMessage(1, RunnerBundle.message("maven.execution.aborted", new Object[0]), null);
            return false;
        }
        if (this.exitCode == 0) {
            this.myConsole.systemMessage(1, RunnerBundle.message("maven.execution.finished", new Object[0]), null);
            return true;
        }
        this.myConsole.systemMessage(3, RunnerBundle.message("maven.execution.terminated.abnormally", this.exitCode), null);
        return false;
    }

    public abstract boolean execute(ProgressIndicator var1);
}

