/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenOrderEnumeratorHandler
extends OrderEnumerationHandler {
    private static final MavenOrderEnumeratorHandler INSTANCE = new MavenOrderEnumeratorHandler();

    public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
        return true;
    }

    public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
        return false;
    }

    public boolean shouldProcessDependenciesRecursively() {
        return false;
    }

    public static class FactoryImpl
    extends OrderEnumerationHandler.Factory {
        public boolean isApplicable(Project project) {
            return MavenProjectsManager.getInstance(project).isMavenizedProject();
        }

        public boolean isApplicable(Module module) {
            MavenProjectsManager manager = MavenProjectsManager.getInstance(module.getProject());
            return manager.isMavenizedModule(module);
        }

        public OrderEnumerationHandler createHandler(Module module) {
            return INSTANCE;
        }
    }
}

