/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerPanel;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.project.MavenDisablePanelCheckbox;

public class MavenRunnerSettingsEditor
extends SettingsEditor<MavenRunConfiguration> {
    private final MavenRunnerPanel myPanel;
    private JCheckBox myUseProjectSettings;

    public MavenRunnerSettingsEditor(Project project) {
        this.myPanel = new MavenRunnerPanel(project, true);
    }

    protected void resetEditorFrom(MavenRunConfiguration runConfiguration) {
        this.myUseProjectSettings.setSelected(runConfiguration.getRunnerSettings() == null);
        if (runConfiguration.getRunnerSettings() == null) {
            MavenRunnerSettings settings = MavenRunner.getInstance(this.myPanel.getProject()).getSettings();
            this.myPanel.getData(settings);
        } else {
            this.myPanel.getData(runConfiguration.getRunnerSettings());
        }
    }

    protected void applyEditorTo(MavenRunConfiguration runConfiguration) throws ConfigurationException {
        if (this.myUseProjectSettings.isSelected()) {
            runConfiguration.setRunnerSettings(null);
        } else if (runConfiguration.getRunnerSettings() != null) {
            this.myPanel.setData(runConfiguration.getRunnerSettings());
        } else {
            MavenRunnerSettings settings = MavenRunner.getInstance(this.myPanel.getProject()).getSettings().clone();
            this.myPanel.setData(settings);
            runConfiguration.setRunnerSettings(settings);
        }
    }

    protected JComponent createEditor() {
        Pair<JPanel, JCheckBox> pair = MavenDisablePanelCheckbox.createPanel(this.myPanel.createComponent(), "Use project settings");
        this.myUseProjectSettings = (JCheckBox)pair.second;
        return (JComponent)pair.first;
    }
}

