/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.utils.MavenLog;

public class SoutMavenConsole
extends MavenConsole {
    public SoutMavenConsole() {
        super(MavenExecutionOptions.LoggingLevel.DEBUG, true);
    }

    public SoutMavenConsole(MavenExecutionOptions.LoggingLevel outputLevel, boolean printStrackTrace) {
        super(outputLevel, printStrackTrace);
    }

    @Override
    public boolean canPause() {
        return false;
    }

    @Override
    public boolean isOutputPaused() {
        return false;
    }

    @Override
    public void setOutputPaused(boolean outputPaused) {
    }

    @Override
    public void attachToProcess(ProcessHandler processHandler) {
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                System.out.print(event.getText());
                MavenLog.LOG.info(StringUtil.trimTrailing((String)event.getText()));
            }

            public void processTerminated(ProcessEvent event) {
                String text = "PROCESS TERMINATED: " + event.getExitCode();
                System.out.println(text);
                MavenLog.LOG.info(StringUtil.trimTrailing((String)text));
            }
        });
    }

    @Override
    protected void doPrint(String text, MavenConsole.OutputType type) {
        System.out.print(text);
        MavenLog.LOG.info(StringUtil.trimTrailing((String)text));
    }
}

