/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.idea.maven.importing.MavenFoldersImporter;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenModifiableModelsProvider;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenModuleImporter {
    public static final String SUREFIRE_PLUGIN_LIBRARY_NAME = "maven-surefire-plugin urls";
    private static final Set<String> IMPORTED_CLASSIFIERS = ImmutableSet.of((Object)"client");
    private static final Map<String, LanguageLevel> MAVEN_IDEA_PLUGIN_LEVELS = ImmutableMap.of((Object)"JDK_1_3", (Object)LanguageLevel.JDK_1_3, (Object)"JDK_1_4", (Object)LanguageLevel.JDK_1_4, (Object)"JDK_1_5", (Object)LanguageLevel.JDK_1_5, (Object)"JDK_1_6", (Object)LanguageLevel.JDK_1_6, (Object)"JDK_1_7", (Object)LanguageLevel.JDK_1_7);
    private final Module myModule;
    private final MavenProjectsTree myMavenTree;
    private final MavenProject myMavenProject;
    private final MavenProjectChanges myMavenProjectChanges;
    private final Map<MavenProject, String> myMavenProjectToModuleName;
    private final MavenImportingSettings mySettings;
    private final MavenModifiableModelsProvider myModifiableModelsProvider;
    private MavenRootModelAdapter myRootModelAdapter;

    public MavenModuleImporter(Module module, MavenProjectsTree mavenTree, MavenProject mavenProject, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, MavenImportingSettings settings, MavenModifiableModelsProvider modifiableModelsProvider) {
        this.myModule = module;
        this.myMavenTree = mavenTree;
        this.myMavenProject = mavenProject;
        this.myMavenProjectChanges = changes;
        this.myMavenProjectToModuleName = mavenProjectToModuleName;
        this.mySettings = settings;
        this.myModifiableModelsProvider = modifiableModelsProvider;
    }

    public ModifiableRootModel getRootModel() {
        return this.myRootModelAdapter.getRootModel();
    }

    public void config(boolean isNewlyCreatedModule) {
        this.myRootModelAdapter = new MavenRootModelAdapter(this.myMavenProject, this.myModule, this.myModifiableModelsProvider);
        this.myRootModelAdapter.init(isNewlyCreatedModule);
        this.configFolders();
        this.configDependencies();
        this.configLanguageLevel();
    }

    public void preConfigFacets() {
        MavenUtil.invokeAndWaitWriteAction(this.myModule.getProject(), new Runnable(){

            @Override
            public void run() {
                if (MavenModuleImporter.this.myModule.isDisposed()) {
                    return;
                }
                ModuleType moduleType = ModuleType.get((Module)MavenModuleImporter.this.myModule);
                for (MavenImporter importer : MavenModuleImporter.this.getSuitableImporters()) {
                    MavenProjectChanges changes;
                    if (MavenModuleImporter.this.myMavenProjectChanges == null) {
                        if (importer.processChangedModulesOnly()) continue;
                        changes = MavenProjectChanges.NONE;
                    } else {
                        changes = MavenModuleImporter.this.myMavenProjectChanges;
                    }
                    if (importer.getModuleType() != moduleType) continue;
                    importer.preProcess(MavenModuleImporter.this.myModule, MavenModuleImporter.this.myMavenProject, changes, MavenModuleImporter.this.myModifiableModelsProvider);
                }
            }
        });
    }

    public void configFacets(final List<MavenProjectsProcessorTask> postTasks) {
        MavenUtil.invokeAndWaitWriteAction(this.myModule.getProject(), new Runnable(){

            @Override
            public void run() {
                if (MavenModuleImporter.this.myModule.isDisposed()) {
                    return;
                }
                ModuleType moduleType = ModuleType.get((Module)MavenModuleImporter.this.myModule);
                for (MavenImporter importer : MavenModuleImporter.this.getSuitableImporters()) {
                    MavenProjectChanges changes;
                    if (MavenModuleImporter.this.myMavenProjectChanges == null) {
                        if (importer.processChangedModulesOnly()) continue;
                        changes = MavenProjectChanges.NONE;
                    } else {
                        changes = MavenModuleImporter.this.myMavenProjectChanges;
                    }
                    if (importer.getModuleType() != moduleType) continue;
                    importer.process(MavenModuleImporter.this.myModifiableModelsProvider, MavenModuleImporter.this.myModule, MavenModuleImporter.this.myRootModelAdapter, MavenModuleImporter.this.myMavenTree, MavenModuleImporter.this.myMavenProject, changes, MavenModuleImporter.this.myMavenProjectToModuleName, postTasks);
                }
            }
        });
    }

    private List<MavenImporter> getSuitableImporters() {
        return this.myMavenProject.getSuitableImporters();
    }

    private void configFolders() {
        new MavenFoldersImporter(this.myMavenProject, this.mySettings, this.myRootModelAdapter).config();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configDependencies() {
        THashSet dependencyTypesFromSettings = new THashSet();
        AccessToken accessToken = ReadAction.start();
        try {
            if (this.myModule.getProject().isDisposed()) {
                return;
            }
            dependencyTypesFromSettings.addAll(MavenProjectsManager.getInstance(this.myModule.getProject()).getImportingSettings().getDependencyTypesAsSet());
        }
        finally {
            accessToken.finish();
        }
        for (MavenArtifact artifact : this.myMavenProject.getDependencies()) {
            String dependencyType = artifact.getType();
            if (!dependencyTypesFromSettings.contains((Object)dependencyType) && !this.myMavenProject.getDependencyTypesFromImporters(SupportedRequestType.FOR_IMPORT).contains(dependencyType)) continue;
            DependencyScope scope = MavenModuleImporter.selectScope(artifact.getScope());
            MavenProject depProject = this.myMavenTree.findProject(artifact.getMavenId());
            if (depProject != null) {
                if (depProject == this.myMavenProject) continue;
                String moduleName = this.myMavenProjectToModuleName.get(depProject);
                if (moduleName == null || this.myMavenTree.isIgnored(depProject)) {
                    MavenArtifact projectsArtifactInRepository = new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), dependencyType, artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), artifact.getExtension(), null, this.myMavenProject.getLocalRepository(), false, false);
                    this.myRootModelAdapter.addLibraryDependency(projectsArtifactInRepository, scope, this.myModifiableModelsProvider, this.myMavenProject);
                    continue;
                }
                boolean isTestJar = "test-jar".equals(dependencyType) || "tests".equals(artifact.getClassifier());
                this.myRootModelAdapter.addModuleDependency(moduleName, scope, isTestJar);
                Element buildHelperCfg = depProject.getPluginGoalConfiguration("org.codehaus.mojo", "build-helper-maven-plugin", "attach-artifact");
                if (buildHelperCfg != null) {
                    this.addAttachArtifactDependency(buildHelperCfg, scope, depProject, artifact);
                }
                if (!IMPORTED_CLASSIFIERS.contains(artifact.getClassifier()) || isTestJar || "system".equals(artifact.getScope()) || "false".equals(System.getProperty("idea.maven.classifier.dep"))) continue;
                MavenArtifact a = new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), dependencyType, artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), artifact.getExtension(), null, this.myMavenProject.getLocalRepository(), false, false);
                this.myRootModelAdapter.addLibraryDependency(a, scope, this.myModifiableModelsProvider, this.myMavenProject);
                continue;
            }
            if ("system".equals(artifact.getScope())) {
                this.myRootModelAdapter.addSystemDependency(artifact, scope);
                continue;
            }
            this.myRootModelAdapter.addLibraryDependency(artifact, scope, this.myModifiableModelsProvider, this.myMavenProject);
        }
        this.configSurefirePlugin();
    }

    private void configSurefirePlugin() {
        LibraryTable moduleLibraryTable = this.myRootModelAdapter.getRootModel().getModuleLibraryTable();
        Library library = moduleLibraryTable.getLibraryByName(SUREFIRE_PLUGIN_LIBRARY_NAME);
        if (library != null) {
            moduleLibraryTable.removeLibrary(library);
        }
    }

    private void addAttachArtifactDependency(Element buildHelperCfg, DependencyScope scope, MavenProject mavenProject, MavenArtifact artifact) {
        Library.ModifiableModel libraryModel = null;
        for (Element artifactsElement : buildHelperCfg.getChildren("artifacts")) {
            for (Element artifactElement : artifactsElement.getChildren("artifact")) {
                VirtualFile file;
                String filePath;
                String typeString = artifactElement.getChildTextTrim("type");
                if (typeString != null && !typeString.equals("jar")) continue;
                OrderRootType rootType = OrderRootType.CLASSES;
                String classifier = artifactElement.getChildTextTrim("classifier");
                if ("sources".equals(classifier)) {
                    rootType = OrderRootType.SOURCES;
                } else if ("javadoc".equals(classifier)) {
                    rootType = JavadocOrderRootType.getInstance();
                }
                if (StringUtil.isEmpty((String)(filePath = artifactElement.getChildTextTrim("file"))) || (file = VfsUtil.findRelativeFile((String)filePath, (VirtualFile)mavenProject.getDirectoryFile())) == null || (file = JarFileSystem.getInstance().getJarRootForLocalFile(file)) == null) continue;
                if (libraryModel == null) {
                    String libraryName = MavenModuleImporter.getAttachedJarsLibName(artifact);
                    Library library = this.myModifiableModelsProvider.getLibraryByName(libraryName);
                    if (library == null) {
                        library = this.myModifiableModelsProvider.createLibrary(libraryName);
                    }
                    libraryModel = this.myModifiableModelsProvider.getLibraryModel(library);
                    LibraryOrderEntry entry = this.myRootModelAdapter.getRootModel().addLibraryEntry(library);
                    entry.setScope(scope);
                }
                libraryModel.addRoot(file, rootType);
            }
        }
    }

    public static String getAttachedJarsLibName(MavenArtifact artifact) {
        String libraryName = artifact.getLibraryName();
        assert (libraryName.startsWith("Maven: "));
        libraryName = "Maven: ATTACHED-JAR: " + libraryName.substring("Maven: ".length());
        return libraryName;
    }

    public static DependencyScope selectScope(String mavenScope) {
        if ("runtime".equals(mavenScope)) {
            return DependencyScope.RUNTIME;
        }
        if ("test".equals(mavenScope)) {
            return DependencyScope.TEST;
        }
        if ("provided".equals(mavenScope)) {
            return DependencyScope.PROVIDED;
        }
        return DependencyScope.COMPILE;
    }

    private void configLanguageLevel() {
        if ("false".equalsIgnoreCase(System.getProperty("idea.maven.configure.language.level"))) {
            return;
        }
        LanguageLevel level = null;
        Element cfg = this.myMavenProject.getPluginConfiguration("com.googlecode", "maven-idea-plugin");
        if (cfg != null) {
            level = MAVEN_IDEA_PLUGIN_LEVELS.get(cfg.getChildTextTrim("jdkLevel"));
        }
        if (level == null) {
            level = LanguageLevel.parse((String)this.myMavenProject.getSourceLevel());
        }
        if (level == null) {
            level = LanguageLevel.JDK_1_5;
        }
        this.myRootModelAdapter.setLanguageLevel(level);
    }
}

