/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.configurers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.jetbrains.idea.maven.importing.configurers.MavenModuleConfigurer;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenEncodingConfigurer
extends MavenModuleConfigurer {
    @Override
    public void configure(MavenProject mavenProject, Project project, Module module) {
        String encoding = mavenProject.getEncoding();
        if (encoding != null) {
            try {
                EncodingProjectManager.getInstance((Project)project).setEncoding(mavenProject.getDirectoryFile(), Charset.forName(encoding));
            }
            catch (UnsupportedCharsetException ignored) {
            }
            catch (IllegalCharsetNameException ignored) {
                // empty catch block
            }
        }
    }
}

