/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashMap;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchPanel;
import org.jetbrains.idea.maven.model.MavenId;

public class MavenArtifactSearchDialog
extends DialogWrapper {
    private List<MavenId> myResult = Collections.emptyList();
    public static List<MavenId> ourResultForTest;
    private TabbedPaneWrapper myTabbedPane;
    private MavenArtifactSearchPanel myArtifactsPanel;
    private MavenArtifactSearchPanel myClassesPanel;
    private final Map<Pair<String, String>, String> myManagedDependenciesMap = new HashMap<Pair<String, String>, String>();
    private final Map<MavenArtifactSearchPanel, Boolean> myOkButtonStates = new THashMap();

    public static List<MavenId> searchForClass(Project project, String className) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            assert (ourResultForTest != null);
            List<MavenId> res = ourResultForTest;
            ourResultForTest = null;
            return res;
        }
        MavenArtifactSearchDialog d = new MavenArtifactSearchDialog(project, className, true);
        if (!d.showAndGet()) {
            return Collections.emptyList();
        }
        return d.getResult();
    }

    public static List<MavenId> searchForArtifact(Project project, Collection<MavenDomDependency> managedDependencies) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            assert (ourResultForTest != null);
            List<MavenId> res = ourResultForTest;
            ourResultForTest = null;
            return res;
        }
        MavenArtifactSearchDialog d = new MavenArtifactSearchDialog(project, "", false);
        d.setManagedDependencies(managedDependencies);
        if (!d.showAndGet()) {
            return Collections.emptyList();
        }
        return d.getResult();
    }

    public void setManagedDependencies(Collection<MavenDomDependency> managedDependencies) {
        this.myManagedDependenciesMap.clear();
        for (MavenDomDependency dependency : managedDependencies) {
            String groupId = dependency.getGroupId().getStringValue();
            String artifactId = dependency.getArtifactId().getStringValue();
            String version = dependency.getVersion().getStringValue();
            if (!StringUtil.isNotEmpty((String)groupId) || !StringUtil.isNotEmpty((String)artifactId) || !StringUtil.isNotEmpty((String)version)) continue;
            this.myManagedDependenciesMap.put((Pair<String, String>)Pair.create((Object)groupId, (Object)artifactId), version);
        }
    }

    private MavenArtifactSearchDialog(Project project, String initialText, boolean classMode) {
        super(project, true);
        this.initComponents(project, initialText, classMode);
        this.setTitle("Maven Artifact Search");
        this.updateOkButtonState();
        this.init();
        this.myArtifactsPanel.scheduleSearch();
        this.myClassesPanel.scheduleSearch();
    }

    private void initComponents(Project project, String initialText, boolean classMode) {
        this.myTabbedPane = new TabbedPaneWrapper((Disposable)project);
        MavenArtifactSearchPanel.Listener listener = new MavenArtifactSearchPanel.Listener(){

            @Override
            public void itemSelected() {
                MavenArtifactSearchDialog.this.clickDefaultButton();
            }

            @Override
            public void canSelectStateChanged(MavenArtifactSearchPanel from, boolean canSelect) {
                MavenArtifactSearchDialog.this.myOkButtonStates.put(from, canSelect);
                MavenArtifactSearchDialog.this.updateOkButtonState();
            }
        };
        this.myArtifactsPanel = new MavenArtifactSearchPanel(project, !classMode ? initialText : "", false, listener, this, this.myManagedDependenciesMap);
        this.myClassesPanel = new MavenArtifactSearchPanel(project, classMode ? initialText : "", true, listener, this, this.myManagedDependenciesMap);
        this.myTabbedPane.addTab("Search for artifact", (JComponent)this.myArtifactsPanel);
        this.myTabbedPane.addTab("Search for class", (JComponent)this.myClassesPanel);
        this.myTabbedPane.setSelectedIndex(classMode ? 1 : 0);
        this.myTabbedPane.getComponent().setPreferredSize((Dimension)JBUI.size((int)900, (int)600));
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MavenArtifactSearchDialog.this.updateOkButtonState();
            }
        });
        this.updateOkButtonState();
    }

    private void updateOkButtonState() {
        Boolean canSelect = this.myOkButtonStates.get(this.myTabbedPane.getSelectedComponent());
        if (canSelect == null) {
            canSelect = false;
        }
        this.setOKActionEnabled(canSelect);
    }

    protected Action getOKAction() {
        Action result = super.getOKAction();
        result.putValue("Name", "Add");
        return result;
    }

    protected JComponent createCenterPanel() {
        return this.myTabbedPane.getComponent();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTabbedPane.getSelectedIndex() == 0 ? this.myArtifactsPanel.getSearchField() : this.myClassesPanel.getSearchField();
    }

    protected String getDimensionServiceKey() {
        return "Maven.ArtifactSearchDialog";
    }

    public List<MavenId> getResult() {
        return this.myResult;
    }

    protected void doOKAction() {
        MavenArtifactSearchPanel panel = this.myTabbedPane.getSelectedIndex() == 0 ? this.myArtifactsPanel : this.myClassesPanel;
        this.myResult = panel.getResult();
        super.doOKAction();
    }
}

