/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.plugins.api;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.regex.Matcher;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;
import org.jetbrains.idea.maven.plugins.api.MavenParamReferenceProvider;
import org.jetbrains.idea.maven.plugins.api.MavenSoftAwareReferenceProvider;

public class MavenFixedValueReferenceProvider
implements MavenParamReferenceProvider,
MavenSoftAwareReferenceProvider {
    private final String[] myValues;
    private boolean mySoft = false;

    public MavenFixedValueReferenceProvider(String[] values) {
        this.myValues = values;
    }

    @Override
    public PsiReference[] getReferencesByElement(PsiElement element, MavenDomConfiguration domCfg, ProcessingContext context) {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        TextRange range = manipulator.getRangeInElement(element);
        String text = range.substring(element.getText());
        Matcher matcher = MavenPropertyResolver.PATTERN.matcher(text);
        if (matcher.find()) {
            return PsiReference.EMPTY_ARRAY;
        }
        return new PsiReference[]{new PsiReferenceBase<PsiElement>(element, this.mySoft){

            public PsiElement resolve() {
                if (this.mySoft) {
                    return null;
                }
                if (Arrays.asList(MavenFixedValueReferenceProvider.this.myValues).contains(this.getValue())) {
                    return this.getElement();
                }
                return null;
            }

            public Object[] getVariants() {
                return MavenFixedValueReferenceProvider.this.myValues;
            }
        }};
    }

    @Override
    public void setSoft(boolean soft) {
        this.mySoft = soft;
    }
}

