/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.plugins.api;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.idea.maven.plugins.api.MavenParamReferenceProvider;
import org.jetbrains.idea.maven.plugins.api.MavenPluginParamInfo;

public class MavenPluginParamReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement((IElementType)XmlTokenType.XML_DATA_CHARACTERS).withParent((ElementPattern)XmlPatterns.xmlText().inFile((ElementPattern)XmlPatterns.xmlFile().withName("pom.xml"))), (PsiReferenceProvider)new MavenPluginParamRefProvider());
    }

    private static class MavenPluginParamRefProvider
    extends PsiReferenceProvider {
        private MavenPluginParamRefProvider() {
        }

        public PsiReference[] getReferencesByElement(PsiElement element, ProcessingContext context) {
            XmlText xmlText = (XmlText)element.getParent();
            if (!MavenPluginParamInfo.isSimpleText(xmlText)) {
                return PsiReference.EMPTY_ARRAY;
            }
            MavenPluginParamInfo.ParamInfoList paramInfos = MavenPluginParamInfo.getParamInfoList(xmlText);
            for (MavenPluginParamInfo.ParamInfo info : paramInfos) {
                MavenParamReferenceProvider providerInstance = info.getProviderInstance();
                if (providerInstance == null) continue;
                return providerInstance.getReferencesByElement((PsiElement)xmlText, paramInfos.getDomCfg(), context);
            }
            return PsiReference.EMPTY_ARRAY;
        }
    }
}

