/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;

public class MavenArtifactIndex {
    private static final MavenArtifactIndex EMPTY_INDEX = new MavenArtifactIndex(Collections.<String, Map<String, List<MavenArtifact>>>emptyMap());
    private final Map<String, Map<String, List<MavenArtifact>>> myData;

    private MavenArtifactIndex(Map<String, Map<String, List<MavenArtifact>>> data) {
        this.myData = data;
    }

    public Map<String, Map<String, List<MavenArtifact>>> getData() {
        return this.myData;
    }

    public List<MavenArtifact> findArtifacts(String groupId, String artifactId) {
        Map<String, List<MavenArtifact>> groupMap = this.myData.get(groupId);
        if (groupMap == null) {
            return Collections.emptyList();
        }
        List<MavenArtifact> res = groupMap.get(artifactId);
        return res == null ? Collections.emptyList() : res;
    }

    public List<MavenArtifact> findArtifacts(MavenId mavenId) {
        if (mavenId == null) {
            return Collections.emptyList();
        }
        return this.findArtifacts(mavenId.getGroupId(), mavenId.getArtifactId(), mavenId.getVersion());
    }

    public MavenArtifact findArtifacts(DependencyConflictId id) {
        for (MavenArtifact artifact : this.findArtifacts(id.getGroupId(), id.getArtifactId())) {
            if (!id.equals(DependencyConflictId.create(artifact))) continue;
            return artifact;
        }
        return null;
    }

    public List<MavenArtifact> findArtifacts(String groupId, String artifactId, String version) {
        Map<String, List<MavenArtifact>> groupMap = this.myData.get(groupId);
        if (groupMap == null) {
            return Collections.emptyList();
        }
        List<MavenArtifact> artifacts = groupMap.get(artifactId);
        if (artifacts == null) {
            return Collections.emptyList();
        }
        SmartList res = new SmartList();
        for (MavenArtifact artifact : artifacts) {
            if (!Comparing.equal((String)version, (String)artifact.getVersion())) continue;
            res.add(artifact);
        }
        return res;
    }

    public static MavenArtifactIndex build(List<MavenArtifact> dependencies) {
        if (dependencies.isEmpty()) {
            return EMPTY_INDEX;
        }
        HashMap<String, Map<String, List<MavenArtifact>>> map = new HashMap<String, Map<String, List<MavenArtifact>>>();
        for (MavenArtifact dep : dependencies) {
            List artifactList;
            String artifactId;
            String groupId = dep.getGroupId();
            if (groupId == null || (artifactId = dep.getArtifactId()) == null) continue;
            HashMap<String, List> groupMap = (HashMap<String, List>)map.get(groupId);
            if (groupMap == null) {
                groupMap = new HashMap<String, List>();
                map.put(groupId, groupMap);
            }
            if ((artifactList = (List)groupMap.get(artifactId)) == null) {
                artifactList = new SmartList();
                groupMap.put(artifactId, artifactList);
            }
            artifactList.add(dep);
        }
        return new MavenArtifactIndex(map);
    }
}

