/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.intellij.execution.process.ProcessHandler;
import java.text.MessageFormat;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.execution.RunnerBundle;

public abstract class MavenConsole {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final int myOutputLevel;
    private boolean isFinished;
    private static final BiMap<String, Integer> PREFIX_TO_LEVEL = ImmutableBiMap.of((Object)"DEBUG", (Object)0, (Object)"INFO", (Object)1, (Object)"WARNING", (Object)2, (Object)"ERROR", (Object)3, (Object)"FATAL_ERROR", (Object)4);

    public MavenConsole(MavenExecutionOptions.LoggingLevel outputLevel, boolean printStrackTrace) {
        this.myOutputLevel = outputLevel.getLevel();
    }

    public boolean isSuppressed(int level) {
        return level < this.myOutputLevel;
    }

    public boolean isSuppressed(String line) {
        return this.isSuppressed(MavenConsole.getLevel(line));
    }

    public abstract boolean canPause();

    public abstract boolean isOutputPaused();

    public abstract void setOutputPaused(boolean var1);

    public boolean isFinished() {
        return this.isFinished;
    }

    public void finish() {
        this.isFinished = true;
    }

    public abstract void attachToProcess(ProcessHandler var1);

    public void printException(Throwable throwable) {
        this.systemMessage(3, RunnerBundle.message("embedded.build.failed", new Object[0]), throwable);
    }

    public void systemMessage(int level, String string, Throwable throwable) {
        this.printMessage(level, string, throwable);
    }

    public void printMessage(int level, String string, Throwable throwable) {
        String message;
        if (this.isSuppressed(level)) {
            return;
        }
        OutputType type = OutputType.NORMAL;
        if (throwable != null || level == 2 || level == 3 || level == 4) {
            type = OutputType.ERROR;
        }
        this.doPrint(MavenConsole.composeLine(level, string), type);
        if (level == 4) {
            this.setOutputPaused(false);
        }
        if (throwable != null && (message = throwable.getMessage()) != null) {
            message = message + LINE_SEPARATOR;
            this.doPrint(LINE_SEPARATOR + MavenConsole.composeLine(3, message), type);
        }
    }

    private static String appendExecutionFailureMessage(String message, String newMessage) {
        if (message == null) {
            return newMessage;
        }
        if (newMessage == null) {
            return message;
        }
        return message + LINE_SEPARATOR + LINE_SEPARATOR + newMessage;
    }

    protected abstract void doPrint(String var1, OutputType var2);

    private static int getLevel(String line) {
        return MavenConsole.getLevelByPrefix(MavenConsole.extractPrefix(line));
    }

    private static String extractPrefix(String line) {
        int closing;
        if (line.startsWith("[") && (closing = line.indexOf("] ", 1)) > 1) {
            return line.substring(1, closing);
        }
        return "";
    }

    private static int getLevelByPrefix(String prefix) {
        Integer level = (Integer)PREFIX_TO_LEVEL.get((Object)prefix);
        return level != null ? level : 2;
    }

    private static String composeLine(int level, String message) {
        return MessageFormat.format("[{0}] {1}", MavenConsole.getPrefixByLevel(level), message);
    }

    private static String getPrefixByLevel(int level) {
        return (String)PREFIX_TO_LEVEL.inverse().get((Object)level);
    }

    public static enum OutputType {
        NORMAL,
        SYSTEM,
        ERROR;

    }
}

