/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Element;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenProfile;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.plugins.api.MavenModelPropertiesPatcher;
import org.jetbrains.idea.maven.project.MavenArtifactIndex;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderProjectLocator;
import org.jetbrains.idea.maven.project.MavenProjectReaderResult;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.Path;

public class MavenProject {
    private static final Key<MavenArtifactIndex> DEPENDENCIES_CACHE_KEY = Key.create((String)"MavenProject.DEPENDENCIES_CACHE_KEY");
    private static final Key<List<String>> FILTERS_CACHE_KEY = Key.create((String)"MavenProject.FILTERS_CACHE_KEY");
    private final VirtualFile myFile;
    private volatile State myState = new State();
    private static Map<String, String> COMPILER_LEVEL_TABLE = ContainerUtil.immutableMapBuilder().put((Object)"1.1", (Object)"1.1").put((Object)"1.2", (Object)"1.2").put((Object)"1.3", (Object)"1.3").put((Object)"1.4", (Object)"1.4").put((Object)"1.5", (Object)"1.5").put((Object)"5", (Object)"1.5").put((Object)"1.6", (Object)"1.6").put((Object)"6", (Object)"1.6").put((Object)"1.7", (Object)"1.7").put((Object)"7", (Object)"1.7").put((Object)"1.8", (Object)"1.8").put((Object)"8", (Object)"1.8").build();

    public static MavenProject read(DataInputStream in) throws IOException {
        String path = in.readUTF();
        int length = in.readInt();
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null) {
            return null;
        }
        ByteArrayInputStream bs = new ByteArrayInputStream(bytes);
        ObjectInputStream os = new ObjectInputStream(bs);
        try {
            MavenProject result = new MavenProject(file);
            result.myState = (State)os.readObject();
            MavenProject mavenProject = result;
            return mavenProject;
        }
        catch (ClassNotFoundException e) {
            IOException ioException = new IOException();
            ioException.initCause(e);
            throw ioException;
        }
        finally {
            os.close();
            bs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.getPath());
        BufferExposingByteArrayOutputStream bs = new BufferExposingByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream((OutputStream)bs);
        try {
            os.writeObject(this.myState);
            out.writeInt(bs.size());
            out.write(bs.getInternalBuffer(), 0, bs.size());
        }
        finally {
            os.close();
            bs.close();
        }
    }

    public MavenProject(VirtualFile file) {
        this.myFile = file;
    }

    private MavenProjectChanges set(MavenProjectReaderResult readerResult, MavenGeneralSettings settings, boolean updateLastReadStamp, boolean resetArtifacts, boolean resetProfiles) {
        State newState = this.myState.clone();
        if (updateLastReadStamp) {
            newState.myLastReadStamp = this.myState.myLastReadStamp + 1L;
        }
        newState.myReadingProblems = readerResult.readingProblems;
        newState.myLocalRepository = settings.getEffectiveLocalRepository();
        newState.myActivatedProfilesIds = readerResult.activatedProfiles;
        MavenModel model = readerResult.mavenModel;
        newState.myMavenId = model.getMavenId();
        if (model.getParent() != null) {
            newState.myParentId = model.getParent().getMavenId();
        }
        newState.myPackaging = model.getPackaging();
        newState.myName = model.getName();
        newState.myFinalName = model.getBuild().getFinalName();
        newState.myDefaultGoal = model.getBuild().getDefaultGoal();
        newState.myBuildDirectory = model.getBuild().getDirectory();
        newState.myOutputDirectory = model.getBuild().getOutputDirectory();
        newState.myTestOutputDirectory = model.getBuild().getTestOutputDirectory();
        MavenProject.doSetFolders(newState, readerResult);
        newState.myFilters = model.getBuild().getFilters();
        newState.myProperties = model.getProperties();
        MavenProject.doSetResolvedAttributes(newState, readerResult, resetArtifacts);
        MavenModelPropertiesPatcher.patch(newState.myProperties, newState.myPlugins);
        newState.myModulesPathsAndNames = MavenProject.collectModulePathsAndNames(model, this.getDirectory());
        Collection<String> newProfiles = MavenProject.collectProfilesIds(model.getProfiles());
        if (resetProfiles || newState.myProfilesIds == null) {
            newState.myProfilesIds = newProfiles;
        } else {
            THashSet mergedProfiles = new THashSet(newState.myProfilesIds);
            mergedProfiles.addAll(newProfiles);
            newState.myProfilesIds = new ArrayList<String>((Collection<String>)mergedProfiles);
        }
        newState.myModelMap = readerResult.nativeModelMap;
        return this.setState(newState);
    }

    private MavenProjectChanges setState(State newState) {
        MavenProjectChanges changes = this.myState.getChanges(newState);
        this.myState = newState;
        return changes;
    }

    private static void doSetResolvedAttributes(State state, MavenProjectReaderResult readerResult, boolean reset) {
        MavenModel model = readerResult.mavenModel;
        THashSet newUnresolvedArtifacts = new THashSet();
        LinkedHashSet<MavenRemoteRepository> newRepositories = new LinkedHashSet<MavenRemoteRepository>();
        LinkedHashSet<MavenArtifact> newDependencies = new LinkedHashSet<MavenArtifact>();
        LinkedHashSet<MavenArtifactNode> newDependencyTree = new LinkedHashSet<MavenArtifactNode>();
        LinkedHashSet<MavenPlugin> newPlugins = new LinkedHashSet<MavenPlugin>();
        LinkedHashSet<MavenArtifact> newExtensions = new LinkedHashSet<MavenArtifact>();
        if (!reset) {
            if (state.myUnresolvedArtifactIds != null) {
                newUnresolvedArtifacts.addAll(state.myUnresolvedArtifactIds);
            }
            if (state.myRemoteRepositories != null) {
                newRepositories.addAll(state.myRemoteRepositories);
            }
            if (state.myDependencies != null) {
                newDependencies.addAll(state.myDependencies);
            }
            if (state.myDependencyTree != null) {
                newDependencyTree.addAll(state.myDependencyTree);
            }
            if (state.myPlugins != null) {
                newPlugins.addAll(state.myPlugins);
            }
            if (state.myExtensions != null) {
                newExtensions.addAll(state.myExtensions);
            }
        }
        newUnresolvedArtifacts.addAll(readerResult.unresolvedArtifactIds);
        newRepositories.addAll(model.getRemoteRepositories());
        newDependencyTree.addAll(model.getDependencyTree());
        newDependencies.addAll(model.getDependencies());
        newPlugins.addAll(model.getPlugins());
        newExtensions.addAll(model.getExtensions());
        state.myUnresolvedArtifactIds = newUnresolvedArtifacts;
        state.myRemoteRepositories = new ArrayList<MavenRemoteRepository>(newRepositories);
        state.myDependencies = new ArrayList<MavenArtifact>(newDependencies);
        state.myDependencyTree = new ArrayList<MavenArtifactNode>(newDependencyTree);
        state.myPlugins = new ArrayList<MavenPlugin>(newPlugins);
        state.myExtensions = new ArrayList<MavenArtifact>(newExtensions);
    }

    private MavenProjectChanges setFolders(MavenProjectReaderResult readerResult) {
        State newState = this.myState.clone();
        MavenProject.doSetFolders(newState, readerResult);
        return this.setState(newState);
    }

    private static void doSetFolders(State newState, MavenProjectReaderResult readerResult) {
        MavenModel model = readerResult.mavenModel;
        newState.mySources = model.getBuild().getSources();
        newState.myTestSources = model.getBuild().getTestSources();
        newState.myResources = model.getBuild().getResources();
        newState.myTestResources = model.getBuild().getTestResources();
    }

    private static Map<String, String> collectModulePathsAndNames(MavenModel mavenModel, String baseDir) {
        String basePath = baseDir + "/";
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> each : MavenProject.collectModulesRelativePathsAndNames(mavenModel).entrySet()) {
            result.put(new Path(basePath + each.getKey()).getPath(), each.getValue());
        }
        return result;
    }

    private static Map<String, String> collectModulesRelativePathsAndNames(MavenModel mavenModel) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String name : mavenModel.getModules()) {
            if ((name = name.trim()).length() == 0) continue;
            String originalName = name;
            if (!(name = FileUtil.toSystemIndependentName((String)name)).endsWith("/")) {
                name = name + "/";
            }
            name = name + "pom.xml";
            result.put(name, originalName);
        }
        return result;
    }

    private static Collection<String> collectProfilesIds(Collection<MavenProfile> profiles) {
        if (profiles == null) {
            return Collections.emptyList();
        }
        THashSet result = new THashSet(profiles.size());
        for (MavenProfile each : profiles) {
            result.add(each.getId());
        }
        return result;
    }

    public long getLastReadStamp() {
        return this.myState.myLastReadStamp;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public String getPath() {
        return this.myFile.getPath();
    }

    public String getDirectory() {
        return this.myFile.getParent().getPath();
    }

    public VirtualFile getDirectoryFile() {
        return this.myFile.getParent();
    }

    public VirtualFile getProfilesXmlFile() {
        return MavenUtil.findProfilesXmlFile(this.myFile);
    }

    public File getProfilesXmlIoFile() {
        return MavenUtil.getProfilesXmlIoFile(this.myFile);
    }

    public boolean hasReadingProblems() {
        return !this.myState.myReadingProblems.isEmpty();
    }

    public String getName() {
        return this.myState.myName;
    }

    public String getDisplayName() {
        State state = this.myState;
        if (StringUtil.isEmptyOrSpaces((String)state.myName)) {
            return StringUtil.notNullize((String)state.myMavenId.getArtifactId());
        }
        return state.myName;
    }

    public Map<String, String> getModelMap() {
        return this.myState.myModelMap;
    }

    public MavenId getMavenId() {
        return this.myState.myMavenId;
    }

    public MavenId getParentId() {
        return this.myState.myParentId;
    }

    public String getPackaging() {
        return this.myState.myPackaging;
    }

    public String getFinalName() {
        return this.myState.myFinalName;
    }

    public String getDefaultGoal() {
        return this.myState.myDefaultGoal;
    }

    public String getBuildDirectory() {
        return this.myState.myBuildDirectory;
    }

    public String getGeneratedSourcesDirectory(boolean testSources) {
        return this.getBuildDirectory() + (testSources ? "/generated-test-sources" : "/generated-sources");
    }

    public String getAnnotationProcessorDirectory(boolean testSources) {
        if (this.getProcMode() == ProcMode.NONE) {
            MavenPlugin bscMavenPlugin = this.findPlugin("org.bsc.maven", "maven-processor-plugin");
            Element cfg = this.getPluginGoalConfiguration(bscMavenPlugin, testSources ? "process-test" : "process");
            if (bscMavenPlugin != null && cfg == null) {
                return this.getBuildDirectory() + "/generated-sources/apt";
            }
            if (cfg != null) {
                String out = MavenJDOMUtil.findChildValueByPath(cfg, "outputDirectory");
                if (out == null && (out = MavenJDOMUtil.findChildValueByPath(cfg, "defaultOutputDirectory")) == null) {
                    return this.getBuildDirectory() + "/generated-sources/apt";
                }
                if (!new File(out).isAbsolute()) {
                    out = this.getDirectory() + '/' + out;
                }
                return out;
            }
        }
        String def = this.getGeneratedSourcesDirectory(testSources) + (testSources ? "/test-annotations" : "/annotations");
        return MavenJDOMUtil.findChildValueByPath(this.getCompilerConfig(), testSources ? "generatedTestSourcesDirectory" : "generatedSourcesDirectory", def);
    }

    public ProcMode getProcMode() {
        Element compilerConfiguration = this.getPluginExecutionConfiguration("org.apache.maven.plugins", "maven-compiler-plugin", "default-compile");
        if (compilerConfiguration == null) {
            compilerConfiguration = this.getCompilerConfig();
        }
        if (compilerConfiguration == null) {
            return ProcMode.BOTH;
        }
        Element procElement = compilerConfiguration.getChild("proc");
        if (procElement != null) {
            String procMode = procElement.getValue();
            return "only".equalsIgnoreCase(procMode) ? ProcMode.ONLY : ("none".equalsIgnoreCase(procMode) ? ProcMode.NONE : ProcMode.BOTH);
        }
        String compilerArgument = compilerConfiguration.getChildTextTrim("compilerArgument");
        if ("-proc:none".equals(compilerArgument)) {
            return ProcMode.NONE;
        }
        if ("-proc:only".equals(compilerArgument)) {
            return ProcMode.ONLY;
        }
        Element compilerArguments = compilerConfiguration.getChild("compilerArgs");
        if (compilerArguments != null) {
            for (Element element : compilerArguments.getChildren()) {
                String arg = element.getValue();
                if ("-proc:none".equals(arg)) {
                    return ProcMode.NONE;
                }
                if (!"-proc:only".equals(arg)) continue;
                return ProcMode.ONLY;
            }
        }
        return ProcMode.BOTH;
    }

    public Map<String, String> getAnnotationProcessorOptions() {
        Element compilerConfig = this.getCompilerConfig();
        if (compilerConfig == null) {
            return Collections.emptyMap();
        }
        if (this.getProcMode() != ProcMode.NONE) {
            return MavenProject.getAnnotationProcessorOptionsFromCompilerConfig(compilerConfig);
        }
        MavenPlugin bscMavenPlugin = this.findPlugin("org.bsc.maven", "maven-processor-plugin");
        if (bscMavenPlugin != null) {
            return MavenProject.getAnnotationProcessorOptionsFromProcessorPlugin(bscMavenPlugin);
        }
        return Collections.emptyMap();
    }

    private static Map<String, String> getAnnotationProcessorOptionsFromCompilerConfig(Element compilerConfig) {
        Element compilerArguments;
        LinkedHashMap<String, String> res = null;
        String compilerArgument = compilerConfig.getChildText("compilerArgument");
        if (!StringUtil.isEmptyOrSpaces((String)compilerArgument)) {
            ParametersList parametersList = new ParametersList();
            parametersList.addParametersString(compilerArgument);
            for (String param : parametersList.getParameters()) {
                int idx;
                if (!param.startsWith("-A") || (idx = param.indexOf(61, 3)) < 0) continue;
                if (res == null) {
                    res = new LinkedHashMap<String, String>();
                }
                res.put(param.substring(2, idx), param.substring(idx + 1));
            }
        }
        if ((compilerArguments = compilerConfig.getChild("compilerArguments")) != null) {
            for (Element e : compilerArguments.getChildren()) {
                String name = e.getName();
                if (name.startsWith("-")) {
                    name = name.substring(1);
                }
                if (name.length() <= 1 || name.charAt(0) != 'A') continue;
                if (res == null) {
                    res = new LinkedHashMap();
                }
                res.put(name.substring(1), e.getTextTrim());
            }
        }
        if (res == null) {
            return Collections.emptyMap();
        }
        return res;
    }

    private static Map<String, String> getAnnotationProcessorOptionsFromProcessorPlugin(MavenPlugin bscMavenPlugin) {
        Element optionsElement;
        Element cfg = bscMavenPlugin.getGoalConfiguration("process");
        if (cfg == null) {
            cfg = bscMavenPlugin.getConfigurationElement();
        }
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        if (cfg != null && (optionsElement = cfg.getChild("options")) != null) {
            for (Element option : optionsElement.getChildren()) {
                res.put(option.getName(), option.getText());
            }
        }
        return res;
    }

    public List<String> getDeclaredAnnotationProcessors() {
        ArrayList<String> result;
        block7: {
            block6: {
                Element compilerConfig = this.getCompilerConfig();
                if (compilerConfig == null) {
                    return null;
                }
                result = new ArrayList<String>();
                if (this.getProcMode() == ProcMode.NONE) break block6;
                Element processors = compilerConfig.getChild("annotationProcessors");
                if (processors == null) break block7;
                for (Element element : processors.getChildren("annotationProcessor")) {
                    String processorClassName = element.getTextTrim();
                    if (processorClassName.isEmpty()) continue;
                    result.add(processorClassName);
                }
                break block7;
            }
            MavenPlugin bscMavenPlugin = this.findPlugin("org.bsc.maven", "maven-processor-plugin");
            if (bscMavenPlugin != null) {
                Element bscProcessors;
                Element bscCfg = bscMavenPlugin.getGoalConfiguration("process");
                if (bscCfg == null) {
                    bscCfg = bscMavenPlugin.getConfigurationElement();
                }
                if (bscCfg != null && (bscProcessors = bscCfg.getChild("processors")) != null) {
                    for (Element element : bscProcessors.getChildren("processor")) {
                        String processorClassName = element.getTextTrim();
                        if (processorClassName.isEmpty()) continue;
                        result.add(processorClassName);
                    }
                }
            }
        }
        return result;
    }

    public String getOutputDirectory() {
        return this.myState.myOutputDirectory;
    }

    public String getTestOutputDirectory() {
        return this.myState.myTestOutputDirectory;
    }

    public List<String> getSources() {
        return this.myState.mySources;
    }

    public List<String> getTestSources() {
        return this.myState.myTestSources;
    }

    public List<MavenResource> getResources() {
        return this.myState.myResources;
    }

    public List<MavenResource> getTestResources() {
        return this.myState.myTestResources;
    }

    public List<String> getFilters() {
        return this.myState.myFilters;
    }

    public List<String> getFilterPropertiesFiles() {
        List<String> res = this.getCachedValue(FILTERS_CACHE_KEY);
        if (res == null) {
            Element files;
            Element propCfg = this.getPluginGoalConfiguration("org.codehaus.mojo", "properties-maven-plugin", "read-project-properties");
            if (propCfg != null && (files = propCfg.getChild("files")) != null) {
                res = new ArrayList<String>();
                for (Element file : files.getChildren("file")) {
                    File f = new File(file.getValue());
                    if (!f.isAbsolute()) {
                        f = new File(this.getDirectory(), file.getValue());
                    }
                    res.add(f.getAbsolutePath());
                }
            }
            if (res == null) {
                res = this.getFilters();
            } else {
                res.addAll(this.getFilters());
            }
            res = this.putCachedValue(FILTERS_CACHE_KEY, res);
        }
        return res;
    }

    public MavenProjectChanges read(MavenGeneralSettings generalSettings, MavenExplicitProfiles profiles, MavenProjectReader reader, MavenProjectReaderProjectLocator locator) {
        return this.set(reader.readProject(generalSettings, this.myFile, profiles, locator), generalSettings, true, false, true);
    }

    public Pair<MavenProjectChanges, NativeMavenProjectHolder> resolve(Project project, MavenGeneralSettings generalSettings, MavenEmbedderWrapper embedder, MavenProjectReader reader, MavenProjectReaderProjectLocator locator, ResolveContext context) throws MavenProcessCanceledException {
        MavenProjectReaderResult result = reader.resolveProject(generalSettings, embedder, this.getFile(), this.getActivatedProfilesIds(), locator);
        MavenProjectChanges changes = this.set(result, generalSettings, false, result.readingProblems.isEmpty(), false);
        if (result.nativeMavenProject != null) {
            for (MavenImporter eachImporter : this.getSuitableImporters()) {
                eachImporter.resolve(project, this, result.nativeMavenProject, embedder, context);
            }
        }
        return Pair.create((Object)changes, (Object)result.nativeMavenProject);
    }

    public Pair<Boolean, MavenProjectChanges> resolveFolders(MavenEmbedderWrapper embedder, MavenImportingSettings importingSettings, MavenConsole console) throws MavenProcessCanceledException {
        MavenProjectReaderResult result = MavenProjectReader.generateSources(embedder, importingSettings, this.getFile(), this.getActivatedProfilesIds(), console);
        if (result == null || !result.readingProblems.isEmpty()) {
            return Pair.create((Object)false, (Object)MavenProjectChanges.NONE);
        }
        MavenProjectChanges changes = this.setFolders(result);
        return Pair.create((Object)true, (Object)changes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCache() {
        State state = this.myState;
        synchronized (state) {
            this.myState.resetCache();
        }
    }

    public boolean isAggregator() {
        return "pom".equals(this.getPackaging()) || !this.getModulePaths().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProjectProblem> getProblems() {
        State state;
        State state2 = state = this.myState;
        synchronized (state2) {
            if (state.myProblemsCache == null) {
                state.myProblemsCache = MavenProject.collectProblems(this.myFile, state);
            }
            return state.myProblemsCache;
        }
    }

    private static List<MavenProjectProblem> collectProblems(VirtualFile file, State state) {
        ArrayList<MavenProjectProblem> result = new ArrayList<MavenProjectProblem>();
        MavenProject.validateParent(file, state, result);
        result.addAll(state.myReadingProblems);
        for (Map.Entry<String, String> each : state.myModulesPathsAndNames.entrySet()) {
            if (LocalFileSystem.getInstance().findFileByPath(each.getKey()) != null) continue;
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.moduleNotFound", each.getValue())));
        }
        MavenProject.validateDependencies(file, state, result);
        MavenProject.validateExtensions(file, state, result);
        MavenProject.validatePlugins(file, state, result);
        return result;
    }

    private static void validateParent(VirtualFile file, State state, List<MavenProjectProblem> result) {
        if (!MavenProject.isParentResolved(state)) {
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.parentNotFound", state.myParentId)));
        }
    }

    private static void validateDependencies(VirtualFile file, State state, List<MavenProjectProblem> result) {
        for (MavenArtifact each : MavenProject.getUnresolvedDependencies(state)) {
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.unresolvedDependency", each.getDisplayStringWithType())));
        }
    }

    private static void validateExtensions(VirtualFile file, State state, List<MavenProjectProblem> result) {
        for (MavenArtifact each : MavenProject.getUnresolvedExtensions(state)) {
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.unresolvedExtension", each.getDisplayStringSimple())));
        }
    }

    private static void validatePlugins(VirtualFile file, State state, List<MavenProjectProblem> result) {
        for (MavenPlugin each : MavenProject.getUnresolvedPlugins(state)) {
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.unresolvedPlugin", each)));
        }
    }

    private static MavenProjectProblem createDependencyProblem(VirtualFile file, String description) {
        return new MavenProjectProblem(file.getPath(), description, MavenProjectProblem.ProblemType.DEPENDENCY);
    }

    private static boolean isParentResolved(State state) {
        return !state.myUnresolvedArtifactIds.contains(state.myParentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenArtifact> getUnresolvedDependencies(State state) {
        State state2 = state;
        synchronized (state2) {
            if (state.myUnresolvedDependenciesCache == null) {
                ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
                for (MavenArtifact each : state.myDependencies) {
                    if (each.isResolved()) continue;
                    result.add(each);
                }
                state.myUnresolvedDependenciesCache = result;
            }
            return state.myUnresolvedDependenciesCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenArtifact> getUnresolvedExtensions(State state) {
        State state2 = state;
        synchronized (state2) {
            if (state.myUnresolvedExtensionsCache == null) {
                ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
                for (MavenArtifact each : state.myExtensions) {
                    if (!state.myUnresolvedArtifactIds.contains(each.getMavenId()) || MavenProject.pomFileExists(state.myLocalRepository, each)) continue;
                    result.add(each);
                }
                state.myUnresolvedExtensionsCache = result;
            }
            return state.myUnresolvedExtensionsCache;
        }
    }

    private static boolean pomFileExists(File localRepository, MavenArtifact artifact) {
        return MavenArtifactUtil.hasArtifactFile(localRepository, artifact.getMavenId(), "pom");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenPlugin> getUnresolvedPlugins(State state) {
        State state2 = state;
        synchronized (state2) {
            if (state.myUnresolvedPluginsCache == null) {
                ArrayList<MavenPlugin> result = new ArrayList<MavenPlugin>();
                for (MavenPlugin each : MavenProject.getDeclaredPlugins(state)) {
                    if (MavenArtifactUtil.hasArtifactFile(state.myLocalRepository, each.getMavenId())) continue;
                    result.add(each);
                }
                state.myUnresolvedPluginsCache = result;
            }
            return state.myUnresolvedPluginsCache;
        }
    }

    public List<VirtualFile> getExistingModuleFiles() {
        LocalFileSystem fs = LocalFileSystem.getInstance();
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        Set<String> pathsInStack = this.getModulePaths();
        for (String each : pathsInStack) {
            VirtualFile f = fs.findFileByPath(each);
            if (f == null) continue;
            result.add(f);
        }
        return result;
    }

    public Set<String> getModulePaths() {
        return this.getModulesPathsAndNames().keySet();
    }

    public Map<String, String> getModulesPathsAndNames() {
        return this.myState.myModulesPathsAndNames;
    }

    public Collection<String> getProfilesIds() {
        return this.myState.myProfilesIds;
    }

    public MavenExplicitProfiles getActivatedProfilesIds() {
        return this.myState.myActivatedProfilesIds;
    }

    public List<MavenArtifact> getDependencies() {
        return this.myState.myDependencies;
    }

    public List<MavenArtifactNode> getDependencyTree() {
        return this.myState.myDependencyTree;
    }

    public Set<String> getSupportedPackagings() {
        HashSet result = ContainerUtil.newHashSet((Object[])new String[]{"pom", "jar", "ejb", "ejb-client", "war", "ear", "bundle", "maven-plugin"});
        for (MavenImporter each : this.getSuitableImporters()) {
            each.getSupportedPackagings(result);
        }
        return result;
    }

    public Set<String> getDependencyTypesFromImporters(SupportedRequestType type) {
        THashSet res = new THashSet();
        for (MavenImporter each : this.getSuitableImporters()) {
            each.getSupportedDependencyTypes((Collection<String>)res, type);
        }
        return res;
    }

    public Set<String> getSupportedDependencyScopes() {
        THashSet result = new THashSet(Arrays.asList("compile", "provided", "runtime", "test", "system"));
        for (MavenImporter each : this.getSuitableImporters()) {
            each.getSupportedDependencyScopes((Collection<String>)result);
        }
        return result;
    }

    public void addDependency(MavenArtifact dependency) {
        State state = this.myState;
        ArrayList<MavenArtifact> dependenciesCopy = new ArrayList<MavenArtifact>(state.myDependencies);
        dependenciesCopy.add(dependency);
        state.myDependencies = dependenciesCopy;
        state.myCache.clear();
    }

    public List<MavenArtifact> findDependencies(MavenProject depProject) {
        return this.findDependencies(depProject.getMavenId());
    }

    public List<MavenArtifact> findDependencies(MavenId id) {
        return this.getDependencyArtifactIndex().findArtifacts(id);
    }

    public List<MavenArtifact> findDependencies(String groupId, String artifactId) {
        return this.getDependencyArtifactIndex().findArtifacts(groupId, artifactId);
    }

    public boolean hasUnresolvedArtifacts() {
        State state = this.myState;
        return !MavenProject.isParentResolved(state) || !MavenProject.getUnresolvedDependencies(state).isEmpty() || !MavenProject.getUnresolvedExtensions(state).isEmpty();
    }

    public boolean hasUnresolvedPlugins() {
        return !MavenProject.getUnresolvedPlugins(this.myState).isEmpty();
    }

    public List<MavenPlugin> getPlugins() {
        return this.myState.myPlugins;
    }

    public List<MavenPlugin> getDeclaredPlugins() {
        return MavenProject.getDeclaredPlugins(this.myState);
    }

    private static List<MavenPlugin> getDeclaredPlugins(State state) {
        return ContainerUtil.findAll(state.myPlugins, (Condition)new Condition<MavenPlugin>(){

            public boolean value(MavenPlugin mavenPlugin) {
                return !mavenPlugin.isDefault();
            }
        });
    }

    public Element getPluginConfiguration(String groupId, String artifactId) {
        return this.getPluginGoalConfiguration(groupId, artifactId, null);
    }

    public Element getPluginGoalConfiguration(String groupId, String artifactId, String goal) {
        return this.getPluginGoalConfiguration(this.findPlugin(groupId, artifactId), goal);
    }

    public Element getPluginGoalConfiguration(MavenPlugin plugin, String goal) {
        if (plugin == null) {
            return null;
        }
        return goal == null ? plugin.getConfigurationElement() : plugin.getGoalConfiguration(goal);
    }

    public Element getPluginExecutionConfiguration(String groupId, String artifactId, String executionId) {
        MavenPlugin plugin = this.findPlugin(groupId, artifactId);
        if (plugin == null) {
            return null;
        }
        return plugin.getExecutionConfiguration(executionId);
    }

    public MavenPlugin findPlugin(String groupId, String artifactId) {
        return this.findPlugin(groupId, artifactId, false);
    }

    public MavenPlugin findPlugin(String groupId, String artifactId, boolean explicitlyDeclaredOnly) {
        List<MavenPlugin> plugins = explicitlyDeclaredOnly ? this.getDeclaredPlugins() : this.getPlugins();
        for (MavenPlugin each : plugins) {
            if (!each.getMavenId().equals(groupId, artifactId)) continue;
            return each;
        }
        return null;
    }

    public String getEncoding() {
        String encoding = this.myState.myProperties.getProperty("project.build.sourceEncoding");
        if (encoding != null) {
            return encoding;
        }
        Element pluginConfiguration = this.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
        if (pluginConfiguration != null) {
            return pluginConfiguration.getChildTextTrim("encoding");
        }
        return null;
    }

    public String getSourceLevel() {
        return this.getCompilerLevel("source");
    }

    public String getTargetLevel() {
        return this.getCompilerLevel("target");
    }

    private String getCompilerLevel(String level) {
        String result = MavenJDOMUtil.findChildValueByPath(this.getCompilerConfig(), level);
        if (result == null) {
            result = this.myState.myProperties.getProperty("maven.compiler." + level);
        }
        return MavenProject.normalizeCompilerLevel(result);
    }

    private Element getCompilerConfig() {
        return this.getPluginConfiguration("org.apache.maven.plugins", "maven-compiler-plugin");
    }

    public static String normalizeCompilerLevel(String level) {
        return COMPILER_LEVEL_TABLE.get(level);
    }

    public Properties getProperties() {
        return this.myState.myProperties;
    }

    public File getLocalRepository() {
        return this.myState.myLocalRepository;
    }

    public List<MavenRemoteRepository> getRemoteRepositories() {
        return this.myState.myRemoteRepositories;
    }

    public List<MavenImporter> getSuitableImporters() {
        return MavenImporter.getSuitableImporters(this);
    }

    public ModuleType getModuleType() {
        List<MavenImporter> importers = this.getSuitableImporters();
        return importers.size() > 0 ? importers.get(0).getModuleType() : StdModuleTypes.JAVA;
    }

    public Pair<String, String> getClassifierAndExtension(MavenArtifact artifact, MavenExtraArtifactType type) {
        for (MavenImporter each : this.getSuitableImporters()) {
            Pair<String, String> result = each.getExtraArtifactClassifierAndExtension(artifact, type);
            if (result == null) continue;
            return result;
        }
        return Pair.create((Object)type.getDefaultClassifier(), (Object)type.getDefaultExtension());
    }

    public MavenArtifactIndex getDependencyArtifactIndex() {
        MavenArtifactIndex res = this.getCachedValue(DEPENDENCIES_CACHE_KEY);
        if (res == null) {
            res = MavenArtifactIndex.build(this.getDependencies());
            res = this.putCachedValue(DEPENDENCIES_CACHE_KEY, res);
        }
        return res;
    }

    public <V> V getCachedValue(Key<V> key) {
        return (V)this.myState.myCache.get(key);
    }

    public <V> V putCachedValue(Key<V> key, V value) {
        ConcurrentHashMap<Key, Object> map = this.myState.myCache;
        Object oldValue = map.putIfAbsent(key, value);
        if (oldValue != null) {
            return (V)oldValue;
        }
        return value;
    }

    public String toString() {
        return this.getMavenId().toString();
    }

    private static class State
    implements Cloneable,
    Serializable {
        long myLastReadStamp = 0L;
        MavenId myMavenId;
        MavenId myParentId;
        String myPackaging;
        String myName;
        String myFinalName;
        String myDefaultGoal;
        String myBuildDirectory;
        String myOutputDirectory;
        String myTestOutputDirectory;
        List<String> mySources;
        List<String> myTestSources;
        List<MavenResource> myResources;
        List<MavenResource> myTestResources;
        List<String> myFilters;
        Properties myProperties;
        List<MavenPlugin> myPlugins;
        List<MavenArtifact> myExtensions;
        List<MavenArtifact> myDependencies;
        List<MavenArtifactNode> myDependencyTree;
        List<MavenRemoteRepository> myRemoteRepositories;
        Map<String, String> myModulesPathsAndNames;
        Map<String, String> myModelMap;
        Collection<String> myProfilesIds;
        MavenExplicitProfiles myActivatedProfilesIds;
        Collection<MavenProjectProblem> myReadingProblems;
        Set<MavenId> myUnresolvedArtifactIds;
        File myLocalRepository;
        volatile List<MavenProjectProblem> myProblemsCache;
        volatile List<MavenArtifact> myUnresolvedDependenciesCache;
        volatile List<MavenPlugin> myUnresolvedPluginsCache;
        volatile List<MavenArtifact> myUnresolvedExtensionsCache;
        transient ConcurrentHashMap<Key, Object> myCache = new ConcurrentHashMap();

        private State() {
        }

        public State clone() {
            try {
                State result = (State)super.clone();
                this.myCache = new ConcurrentHashMap();
                result.resetCache();
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        private void resetCache() {
            this.myProblemsCache = null;
            this.myUnresolvedDependenciesCache = null;
            this.myUnresolvedPluginsCache = null;
            this.myUnresolvedExtensionsCache = null;
            this.myCache.clear();
        }

        public MavenProjectChanges getChanges(State other) {
            if (this.myLastReadStamp == 0L) {
                return MavenProjectChanges.ALL;
            }
            MavenProjectChanges result = new MavenProjectChanges();
            result.packaging = !Comparing.equal((String)this.myPackaging, (String)other.myPackaging);
            result.output = !Comparing.equal((String)this.myFinalName, (String)other.myFinalName) || !Comparing.equal((String)this.myBuildDirectory, (String)other.myBuildDirectory) || !Comparing.equal((String)this.myOutputDirectory, (String)other.myOutputDirectory) || !Comparing.equal((String)this.myTestOutputDirectory, (String)other.myTestOutputDirectory);
            result.sources = !Comparing.equal(this.mySources, other.mySources) || !Comparing.equal(this.myTestSources, other.myTestSources) || !Comparing.equal(this.myResources, other.myResources) || !Comparing.equal(this.myTestResources, other.myTestResources);
            boolean repositoryChanged = !Comparing.equal((Object)this.myLocalRepository, (Object)other.myLocalRepository);
            result.dependencies = repositoryChanged || !Comparing.equal(this.myDependencies, other.myDependencies);
            result.plugins = repositoryChanged || !Comparing.equal(this.myPlugins, other.myPlugins);
            return result;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.myCache = new ConcurrentHashMap();
        }
    }

    public static enum ProcMode {
        BOTH,
        ONLY,
        NONE;

    }
}

