/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.server.MavenServerConsole;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public abstract class MavenEmbedderWrapper
extends RemoteObjectWrapper<MavenServerEmbedder> {
    private Customization myCustomization;

    public MavenEmbedderWrapper(RemoteObjectWrapper<?> parent) {
        super(parent);
    }

    @Override
    protected synchronized void onWrappeeCreated() throws RemoteException {
        super.onWrappeeCreated();
        if (this.myCustomization != null) {
            this.doCustomize();
        }
    }

    public void customizeForResolve(MavenConsole console, MavenProgressIndicator indicator) {
        this.setCustomization(console, indicator, null, false, false);
        this.perform(new RemoteObjectWrapper.Retriable<Object>(){

            @Override
            public Object execute() throws RemoteException {
                MavenEmbedderWrapper.this.doCustomize();
                return null;
            }
        });
    }

    public void customizeForResolve(MavenWorkspaceMap workspaceMap, MavenConsole console, MavenProgressIndicator indicator, boolean alwaysUpdateSnapshot) {
        this.setCustomization(console, indicator, workspaceMap, false, alwaysUpdateSnapshot);
        this.perform(new RemoteObjectWrapper.Retriable<Object>(){

            @Override
            public Object execute() throws RemoteException {
                MavenEmbedderWrapper.this.doCustomize();
                return null;
            }
        });
    }

    public void customizeForStrictResolve(MavenWorkspaceMap workspaceMap, MavenConsole console, MavenProgressIndicator indicator) {
        this.setCustomization(console, indicator, workspaceMap, true, false);
        this.perform(new RemoteObjectWrapper.Retriable<Object>(){

            @Override
            public Object execute() throws RemoteException {
                MavenEmbedderWrapper.this.doCustomize();
                return null;
            }
        });
    }

    private synchronized void doCustomize() throws RemoteException {
        ((MavenServerEmbedder)this.getOrCreateWrappee()).customize(this.myCustomization.workspaceMap, this.myCustomization.failOnUnresolvedDependency, this.myCustomization.console, this.myCustomization.indicator, this.myCustomization.alwaysUpdateSnapshot);
    }

    public MavenServerExecutionResult resolveProject(final VirtualFile file, final Collection<String> activeProfiles, final Collection<String> inactiveProfiles) throws MavenProcessCanceledException {
        return this.perform(new RemoteObjectWrapper.RetriableCancelable<MavenServerExecutionResult>(){

            @Override
            public MavenServerExecutionResult execute() throws RemoteException, MavenServerProcessCanceledException {
                return ((MavenServerEmbedder)MavenEmbedderWrapper.this.getOrCreateWrappee()).resolveProject(new File(file.getPath()), activeProfiles, inactiveProfiles);
            }
        });
    }

    public String evaluateEffectivePom(final VirtualFile file, final Collection<String> activeProfiles, final Collection<String> inactiveProfiles) throws MavenProcessCanceledException {
        return this.perform(new RemoteObjectWrapper.RetriableCancelable<String>(){

            @Override
            public String execute() throws RemoteException, MavenServerProcessCanceledException {
                return ((MavenServerEmbedder)MavenEmbedderWrapper.this.getOrCreateWrappee()).evaluateEffectivePom(new File(file.getPath()), new ArrayList(activeProfiles), new ArrayList(inactiveProfiles));
            }
        });
    }

    public MavenArtifact resolve(final MavenArtifactInfo info, final List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        return this.perform(new RemoteObjectWrapper.RetriableCancelable<MavenArtifact>(){

            @Override
            public MavenArtifact execute() throws RemoteException, MavenServerProcessCanceledException {
                return ((MavenServerEmbedder)MavenEmbedderWrapper.this.getOrCreateWrappee()).resolve(info, remoteRepositories);
            }
        });
    }

    public List<MavenArtifact> resolveTransitively(final List<MavenArtifactInfo> artifacts, final List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        return this.perform(new RemoteObjectWrapper.RetriableCancelable<List<MavenArtifact>>(){

            @Override
            public List<MavenArtifact> execute() throws RemoteException, MavenServerProcessCanceledException {
                return ((MavenServerEmbedder)MavenEmbedderWrapper.this.getOrCreateWrappee()).resolveTransitively(artifacts, remoteRepositories);
            }
        });
    }

    public Collection<MavenArtifact> resolvePlugin(MavenPlugin plugin, List<MavenRemoteRepository> repositories, NativeMavenProjectHolder nativeMavenProject, boolean transitive) throws MavenProcessCanceledException {
        int id;
        try {
            id = nativeMavenProject.getId();
        }
        catch (RemoteException e) {
            return Collections.emptyList();
        }
        try {
            return ((MavenServerEmbedder)this.getOrCreateWrappee()).resolvePlugin(plugin, repositories, id, transitive);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
            return Collections.emptyList();
        }
        catch (MavenServerProcessCanceledException e) {
            throw new MavenProcessCanceledException();
        }
    }

    public MavenServerExecutionResult execute(final VirtualFile file, final Collection<String> activeProfiles, final Collection<String> inactiveProfiles, final List<String> goals) throws MavenProcessCanceledException {
        return this.perform(new RemoteObjectWrapper.RetriableCancelable<MavenServerExecutionResult>(){

            @Override
            public MavenServerExecutionResult execute() throws RemoteException, MavenServerProcessCanceledException {
                return ((MavenServerEmbedder)MavenEmbedderWrapper.this.getOrCreateWrappee()).execute(new File(file.getPath()), activeProfiles, inactiveProfiles, goals, Collections.emptyList(), false, false);
            }
        });
    }

    public MavenServerExecutionResult execute(final VirtualFile file, final Collection<String> activeProfiles, final Collection<String> inactiveProfiles, final List<String> goals, final List<String> selectedProjects, final boolean alsoMake, final boolean alsoMakeDependents) throws MavenProcessCanceledException {
        return this.perform(new RemoteObjectWrapper.RetriableCancelable<MavenServerExecutionResult>(){

            @Override
            public MavenServerExecutionResult execute() throws RemoteException, MavenServerProcessCanceledException {
                return ((MavenServerEmbedder)MavenEmbedderWrapper.this.getOrCreateWrappee()).execute(new File(file.getPath()), activeProfiles, inactiveProfiles, goals, selectedProjects, alsoMake, alsoMakeDependents);
            }
        });
    }

    public void reset() {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.reset();
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
        this.resetCustomization();
    }

    public void release() {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.release();
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
        this.resetCustomization();
    }

    public void clearCaches() {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.clearCaches();
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    public void clearCachesFor(MavenId projectId) {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.clearCachesFor(projectId);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    private synchronized void setCustomization(MavenConsole console, MavenProgressIndicator indicator, MavenWorkspaceMap workspaceMap, boolean failOnUnresolvedDependency, boolean alwaysUpdateSnapshot) {
        this.resetCustomization();
        this.myCustomization = new Customization(MavenServerManager.wrapAndExport(console), MavenServerManager.wrapAndExport(indicator), workspaceMap, failOnUnresolvedDependency, alwaysUpdateSnapshot);
    }

    private synchronized void resetCustomization() {
        if (this.myCustomization == null) {
            return;
        }
        try {
            UnicastRemoteObject.unexportObject((Remote)this.myCustomization.console, true);
        }
        catch (NoSuchObjectException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        try {
            UnicastRemoteObject.unexportObject((Remote)this.myCustomization.indicator, true);
        }
        catch (NoSuchObjectException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        this.myCustomization = null;
    }

    private static class Customization {
        private final MavenServerConsole console;
        private final MavenServerProgressIndicator indicator;
        private final MavenWorkspaceMap workspaceMap;
        private final boolean failOnUnresolvedDependency;
        private final boolean alwaysUpdateSnapshot;

        private Customization(MavenServerConsole console, MavenServerProgressIndicator indicator, MavenWorkspaceMap workspaceMap, boolean failOnUnresolvedDependency, boolean alwaysUpdateSnapshot) {
            this.console = console;
            this.indicator = indicator;
            this.workspaceMap = workspaceMap;
            this.failOnUnresolvedDependency = failOnUnresolvedDependency;
            this.alwaysUpdateSnapshot = alwaysUpdateSnapshot;
        }
    }
}

