/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.keymap.impl.ui.EditKeymapsDialog;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class AssignShortcutAction
extends MavenAction {
    @Override
    protected boolean isAvailable(AnActionEvent e) {
        DataContext context = e.getDataContext();
        return super.isAvailable(e) && !AssignShortcutAction.isIgnoredProject(context) && AssignShortcutAction.getGoalActionId(context) != null;
    }

    private static boolean isIgnoredProject(DataContext context) {
        MavenProject project = MavenActionUtil.getMavenProject(context);
        if (project == null) {
            return false;
        }
        MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(context);
        return projectsManager != null && projectsManager.isIgnored(project);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext context = e.getDataContext();
        String actionId = AssignShortcutAction.getGoalActionId(context);
        if (actionId != null) {
            new EditKeymapsDialog(MavenActionUtil.getProject(context), actionId).show();
        }
    }

    private static String getGoalActionId(DataContext context) {
        List goals = (List)MavenDataKeys.MAVEN_GOALS.getData(context);
        if (goals == null || goals.size() != 1) {
            return null;
        }
        MavenProject project = MavenActionUtil.getMavenProject(context);
        if (project == null) {
            return null;
        }
        String goal = (String)goals.get(0);
        MavenShortcutsManager shortcutsManager = AssignShortcutAction.getShortcutsManager(context);
        return shortcutsManager != null ? shortcutsManager.getActionId(project.getPath(), goal) : null;
    }

    protected static MavenShortcutsManager getShortcutsManager(DataContext context) {
        Project project = MavenActionUtil.getProject(context);
        if (project == null) {
            return null;
        }
        return MavenShortcutsManager.getInstance(project);
    }
}

