/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks.actions;

import com.intellij.execution.RunManagerEx;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.List;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTask;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTasksProvider;
import org.jetbrains.idea.maven.tasks.actions.MavenExecuteBeforeRunDialog;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;
import org.jetbrains.idea.maven.utils.actions.MavenToggleAction;

public class ToggleBeforeRunTaskAction
extends MavenToggleAction {
    @Override
    protected boolean isAvailable(AnActionEvent e) {
        return super.isAvailable(e) && ToggleBeforeRunTaskAction.getTaskDesc(e.getDataContext()) != null;
    }

    @Override
    protected boolean doIsSelected(AnActionEvent e) {
        DataContext context = e.getDataContext();
        Pair<MavenProject, String> desc = ToggleBeforeRunTaskAction.getTaskDesc(context);
        if (desc != null) {
            RunManagerEx runManager = ToggleBeforeRunTaskAction.getRunManager(context);
            if (runManager == null) {
                return false;
            }
            for (MavenBeforeRunTask each : runManager.getBeforeRunTasks(MavenBeforeRunTasksProvider.ID)) {
                if (!each.isFor((MavenProject)desc.first, (String)desc.second)) continue;
                return true;
            }
        }
        return false;
    }

    public void setSelected(AnActionEvent e, boolean state) {
        DataContext context = e.getDataContext();
        Pair<MavenProject, String> desc = ToggleBeforeRunTaskAction.getTaskDesc(context);
        if (desc != null) {
            new MavenExecuteBeforeRunDialog(MavenActionUtil.getProject(context), (MavenProject)desc.first, (String)desc.second).show();
        }
    }

    protected static Pair<MavenProject, String> getTaskDesc(DataContext context) {
        List goals = (List)MavenDataKeys.MAVEN_GOALS.getData(context);
        if (goals == null || goals.size() != 1) {
            return null;
        }
        MavenProject mavenProject = MavenActionUtil.getMavenProject(context);
        if (mavenProject == null) {
            return null;
        }
        return Pair.create((Object)mavenProject, goals.get(0));
    }

    private static RunManagerEx getRunManager(DataContext context) {
        Project project = MavenActionUtil.getProject(context);
        if (project == null) {
            return null;
        }
        return RunManagerEx.getInstanceEx((Project)project);
    }
}

