/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.tasks.MavenCompilerTask;
import org.jetbrains.idea.maven.tasks.MavenTasksManager;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;
import org.jetbrains.idea.maven.utils.actions.MavenToggleAction;

public abstract class ToggleCompilerTasksAction
extends MavenToggleAction {
    private final MavenTasksManager.Phase myPhase;

    protected ToggleCompilerTasksAction(MavenTasksManager.Phase phase) {
        this.myPhase = phase;
    }

    @Override
    protected boolean isAvailable(AnActionEvent e) {
        return super.isAvailable(e) && !ToggleCompilerTasksAction.getTasks(e.getDataContext()).isEmpty();
    }

    @Override
    protected boolean doIsSelected(AnActionEvent e) {
        DataContext context = e.getDataContext();
        return this.hasTask(ToggleCompilerTasksAction.getTasksManager(context), ToggleCompilerTasksAction.getTasks(context).get(0));
    }

    public void setSelected(AnActionEvent e, boolean state) {
        DataContext context = e.getDataContext();
        MavenTasksManager tasksManager = ToggleCompilerTasksAction.getTasksManager(context);
        List<MavenCompilerTask> tasks = ToggleCompilerTasksAction.getTasks(context);
        if (tasksManager == null) {
            return;
        }
        if (state) {
            this.addTasks(tasksManager, tasks);
        } else {
            this.removeTasks(tasksManager, tasks);
        }
    }

    protected static List<MavenCompilerTask> getTasks(DataContext context) {
        List goals = (List)MavenDataKeys.MAVEN_GOALS.getData(context);
        if (goals == null || goals.isEmpty()) {
            return Collections.emptyList();
        }
        MavenProject project = MavenActionUtil.getMavenProject(context);
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<MavenCompilerTask> result = new ArrayList<MavenCompilerTask>();
        for (String each : goals) {
            result.add(new MavenCompilerTask(project.getPath(), each));
        }
        return result;
    }

    protected boolean hasTask(MavenTasksManager manager, MavenCompilerTask task) {
        if (manager == null) {
            return false;
        }
        return manager.isCompileTaskOfPhase(task, this.myPhase);
    }

    protected void addTasks(MavenTasksManager manager, List<MavenCompilerTask> tasks) {
        manager.addCompileTasks(tasks, this.myPhase);
    }

    protected void removeTasks(MavenTasksManager manager, List<MavenCompilerTask> tasks) {
        manager.removeCompileTasks(tasks, this.myPhase);
    }

    private static MavenTasksManager getTasksManager(DataContext context) {
        Project project = MavenActionUtil.getProject(context);
        if (project == null) {
            return null;
        }
        return MavenTasksManager.getInstance(project);
    }
}

