/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerConfigurable;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.indices.MavenRepositoriesConfigurable;
import org.jetbrains.idea.maven.project.MavenGeneralConfigurable;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenIgnoredFilesConfigurable;
import org.jetbrains.idea.maven.project.MavenImportingConfigurable;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenTestRunningConfigurable;

public class MavenSettings
implements SearchableConfigurable.Parent {
    public static final String DISPLAY_NAME = "Maven";
    private final Project myProject;
    private final Configurable myConfigurable;
    private final List<Configurable> myChildren;

    public MavenSettings(Project project) {
        this.myProject = project;
        this.myConfigurable = new MavenGeneralConfigurable(){

            @Override
            protected MavenGeneralSettings getState() {
                return MavenProjectsManager.getInstance(MavenSettings.this.myProject).getGeneralSettings();
            }
        };
        this.myChildren = new ArrayList<Configurable>();
        this.myChildren.add((Configurable)new MavenImportingConfigurable(this.myProject));
        this.myChildren.add((Configurable)new MavenIgnoredFilesConfigurable(this.myProject));
        this.myChildren.add((Configurable)new MyMavenRunnerConfigurable(project));
        this.myChildren.add((Configurable)new MavenTestRunningConfigurable(project));
        if (!this.myProject.isDefault()) {
            this.myChildren.add((Configurable)new MavenRepositoriesConfigurable(this.myProject));
        }
    }

    public boolean hasOwnContent() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        return this.myConfigurable.createComponent();
    }

    public boolean isModified() {
        return this.myConfigurable.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myConfigurable.apply();
    }

    public void reset() {
        this.myConfigurable.reset();
    }

    public void disposeUIResources() {
        this.myConfigurable.disposeUIResources();
    }

    public Configurable[] getConfigurables() {
        return this.myChildren.toArray(new Configurable[this.myChildren.size()]);
    }

    public String getId() {
        return MavenSettings.class.getSimpleName();
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return this.myConfigurable.getHelpTopic();
    }

    public static class MyMavenRunnerConfigurable
    extends MavenRunnerConfigurable {
        public MyMavenRunnerConfigurable(Project project) {
            super(project, false);
        }

        @Override
        protected MavenRunnerSettings getState() {
            return MavenRunner.getInstance(this.myProject).getState();
        }
    }
}

