/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.vfs.VirtualFile;
import icons.MavenIcons;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryEditor;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public class RepositoryLibraryType
extends LibraryType<RepositoryLibraryProperties> {
    private static final PersistentLibraryKind<RepositoryLibraryProperties> LIBRARY_KIND = new PersistentLibraryKind<RepositoryLibraryProperties>("repository"){

        public RepositoryLibraryProperties createDefaultProperties() {
            return new RepositoryLibraryProperties();
        }
    };

    public static RepositoryLibraryType getInstance() {
        return (RepositoryLibraryType)((Object)EP_NAME.findExtension(RepositoryLibraryType.class));
    }

    public RepositoryLibraryType() {
        super(LIBRARY_KIND);
    }

    public String getCreateActionName() {
        return "From Maven...";
    }

    public NewLibraryConfiguration createNewLibrary(JComponent parentComponent, VirtualFile contextDirectory, Project project) {
        return RepositoryAttachHandler.chooseLibraryAndDownload(project, null, parentComponent);
    }

    public LibraryPropertiesEditor createPropertiesEditor(LibraryEditorComponent<RepositoryLibraryProperties> component) {
        return new RepositoryLibraryEditor(component, this);
    }

    public String getDescription(RepositoryLibraryProperties properties) {
        String mavenIdKey = properties.getMavenId();
        return "Library " + (mavenIdKey != null ? mavenIdKey + " " : "") + "from Maven repository";
    }

    public Icon getIcon() {
        return MavenIcons.MavenLogo;
    }
}

