/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.vfs;

import com.intellij.lang.properties.IProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.vfs.MavenPropertiesVirtualFile;

public class MavenPropertiesVirtualFileSystem
extends DummyFileSystem {
    @NonNls
    public static final String PROTOCOL = "maven-properties";
    @NonNls
    public static final String SYSTEM_PROPERTIES_FILE = "System.properties";
    @NonNls
    public static final String ENV_PROPERTIES_FILE = "Environment.properties";
    public static final String[] PROPERTIES_FILES = new String[]{"System.properties", "Environment.properties"};
    private VirtualFile mySystemPropertiesFile;
    private VirtualFile myEnvPropertiesFile;

    public static MavenPropertiesVirtualFileSystem getInstance() {
        return (MavenPropertiesVirtualFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public VirtualFile getSystemPropertiesFile() {
        if (this.mySystemPropertiesFile == null) {
            Properties systemProperties = new Properties();
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                String key;
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || (key = (String)entry.getKey()).startsWith("idea.")) continue;
                systemProperties.setProperty(key, (String)entry.getValue());
            }
            this.mySystemPropertiesFile = new MavenPropertiesVirtualFile(SYSTEM_PROPERTIES_FILE, systemProperties, (VirtualFileSystem)this);
        }
        return this.mySystemPropertiesFile;
    }

    public VirtualFile getEnvPropertiesFile() {
        if (this.myEnvPropertiesFile == null) {
            Properties envProperties = new Properties();
            for (Map.Entry<String, String> each : System.getenv().entrySet()) {
                String key = each.getKey();
                if (key.startsWith("=")) continue;
                envProperties.setProperty(SystemInfo.isWindows ? key.toUpperCase() : key, each.getValue());
            }
            this.myEnvPropertiesFile = new MavenPropertiesVirtualFile(ENV_PROPERTIES_FILE, envProperties, (VirtualFileSystem)this);
        }
        return this.myEnvPropertiesFile;
    }

    public synchronized VirtualFile findFileByPath(@NonNls String path) {
        if (path.equals(SYSTEM_PROPERTIES_FILE)) {
            return this.getSystemPropertiesFile();
        }
        if (path.equals(ENV_PROPERTIES_FILE)) {
            return this.getEnvPropertiesFile();
        }
        return null;
    }

    public IProperty findSystemProperty(Project project, String propertyName) {
        return MavenDomUtil.findProperty(project, this.getSystemPropertiesFile(), propertyName);
    }

    public IProperty findEnvProperty(Project project, String propertyName) {
        return MavenDomUtil.findProperty(project, this.getEnvPropertiesFile(), propertyName);
    }
}

