/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.emulator;

import com.jediterm.terminal.TerminalColor;
import java.awt.Color;

public abstract class ColorPalette {
    public static final ColorPalette XTERM_PALETTE = new ColorPalette(){

        public Color[] getIndexColors() {
            return new Color[]{new Color(0), new Color(0xCD0000), new Color(52480), new Color(0xCDCD00), new Color(2003199), new Color(0xCD00CD), new Color(52685), new Color(0xE5E5E5), new Color(0x4C4C4C), new Color(0xFF0000), new Color(65280), new Color(0xFFFF00), new Color(4620980), new Color(0xFF00FF), new Color(65535), new Color(0xFFFFFF)};
        }
    };
    public static final ColorPalette WINDOWS_PALETTE = new ColorPalette(){

        public Color[] getIndexColors() {
            return new Color[]{new Color(0), new Color(0x800000), new Color(32768), new Color(0x808000), new Color(128), new Color(0x800080), new Color(32896), new Color(0xC0C0C0), new Color(0x808080), new Color(0xFF0000), new Color(65280), new Color(0xFFFF00), new Color(4620980), new Color(0xFF00FF), new Color(65535), new Color(0xFFFFFF)};
        }
    };
    private static final TerminalColor[] COL_RES_256 = new TerminalColor[240];

    public abstract Color[] getIndexColors();

    public Color getColor(TerminalColor color) {
        if (color.isIndexed()) {
            return this.getIndexColors()[color.getIndex()];
        }
        return color.toAwtColor();
    }

    public static TerminalColor getIndexedColor(int index) {
        return index < 16 ? TerminalColor.index(index) : ColorPalette.getXTerm256(index);
    }

    private static TerminalColor getXTerm256(int index) {
        return index < 256 ? COL_RES_256[index - 16] : null;
    }

    static {
        for (int red = 0; red < 6; ++red) {
            for (int green = 0; green < 6; ++green) {
                for (int blue = 0; blue < 6; ++blue) {
                    int code = 36 * red + 6 * green + blue;
                    ColorPalette.COL_RES_256[code] = new TerminalColor(red > 0 ? 40 * red + 55 : 0, green > 0 ? 40 * green + 55 : 0, blue > 0 ? 40 * blue + 55 : 0);
                }
            }
        }
        for (int gray = 0; gray < 24; ++gray) {
            int level = 10 * gray + 8;
            ColorPalette.COL_RES_256[216 + gray] = new TerminalColor(level, level, level);
        }
    }
}

