/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.BootstrapClassLoaderUtil;
import com.intellij.openapi.application.PathManager;
import java.io.File;
import java.lang.reflect.Method;

public class BootstrapUITestRunner {
    private static final String JUNIT_CORE_CLASS = "org.junit.runner.JUnitCore";
    private static final String REQUEST_CLASS = "org.junit.runner.Request";
    private static final String RESULT_CLASS = "org.junit.runner.Result";
    private static final String UITESTS_ROOT = "plugins/android/ui-tests-dir";
    private static final String ANDROID_ROOT = "plugins/android/lib";
    private static final String SUITE_CLASS = "com.android.tools.idea.tests.gui.GuiTestSuite";

    private static String getTestClasspath() {
        String ideaHome = PathManager.getHomePath();
        StringBuilder classpath = new StringBuilder();
        classpath.append(new File(ideaHome, UITESTS_ROOT).getAbsolutePath());
        for (File entry : new File(ideaHome, ANDROID_ROOT).listFiles()) {
            if (!entry.isFile() || !entry.getName().endsWith(".jar")) continue;
            classpath.append(File.pathSeparator);
            classpath.append(entry.getAbsolutePath());
        }
        return classpath.toString();
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("idea.additional.classpath", BootstrapUITestRunner.getTestClasspath());
        ClassLoader newClassLoader = BootstrapClassLoaderUtil.initClassLoader(true);
        Class<?> testClass = Class.forName(SUITE_CLASS, true, newClassLoader);
        Class<?> jUnitCore = Class.forName(JUNIT_CORE_CLASS, true, newClassLoader);
        Object c = jUnitCore.newInstance();
        Class<?> request = Class.forName(REQUEST_CLASS, true, newClassLoader);
        Method runMethod = jUnitCore.getMethod("run", request);
        Method aClassMethod = request.getMethod("aClass", Class.class);
        Object r = runMethod.invoke(c, aClassMethod.invoke(request, testClass));
        Class<?> result = Class.forName(RESULT_CLASS, true, newClassLoader);
        System.out.printf("Tests run: %1$d, Failures: %2$d, Ignored: %3$d, Time elapsed: %4$.3f(s)\n", result.getMethod("getRunCount", new Class[0]).invoke(r, new Object[0]), result.getMethod("getFailureCount", new Class[0]).invoke(r, new Object[0]), result.getMethod("getIgnoreCount", new Class[0]).invoke(r, new Object[0]), (double)((Long)result.getMethod("getRunTime", new Class[0]).invoke(r, new Object[0])).longValue() / 1000.0);
        if (!((Boolean)result.getMethod("wasSuccessful", new Class[0]).invoke(r, new Object[0])).booleanValue()) {
            System.exit(1);
        }
    }
}

