/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class ImportSettingsFilenameFilter
implements FilenameFilter,
Serializable {
    @NonNls
    static final String SETTINGS_JAR_MARKER = "IntelliJ IDEA Global Settings";
    private final Set<String> myRelativeNamesToExtract;

    public ImportSettingsFilenameFilter(Set<String> relativeNamesToExtract) {
        this.myRelativeNamesToExtract = relativeNamesToExtract;
    }

    @Override
    public boolean accept(File dir, String name) {
        if (name.equals(SETTINGS_JAR_MARKER)) {
            return false;
        }
        File configPath = new File(PathManager.getConfigPath());
        String rPath = FileUtil.getRelativePath((File)configPath, (File)new File(dir, name));
        assert (rPath != null);
        String relativePath = FileUtil.toSystemIndependentName((String)rPath);
        for (String allowedRelPath : this.myRelativeNamesToExtract) {
            if (!relativePath.startsWith(allowedRelPath)) continue;
            return true;
        }
        return false;
    }
}

