/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NonNls;

public class StartupActionScriptManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.startup.StartupActionScriptManager");
    @NonNls
    public static final String STARTUP_WIZARD_MODE = "StartupWizardMode";
    @NonNls
    private static final String ACTION_SCRIPT_FILE = "action.script";

    private StartupActionScriptManager() {
    }

    public static synchronized void executeActionScript() throws IOException {
        List<ActionCommand> commands = StartupActionScriptManager.loadActionScript();
        for (ActionCommand actionCommand : commands) {
            actionCommand.execute();
        }
        if (commands.size() > 0) {
            commands.clear();
            StartupActionScriptManager.saveActionScript(commands);
        }
    }

    public static synchronized void addActionCommand(ActionCommand command) throws IOException {
        if (Boolean.getBoolean(STARTUP_WIZARD_MODE)) {
            command.execute();
            return;
        }
        List<ActionCommand> commands = StartupActionScriptManager.loadActionScript();
        commands.add(command);
        StartupActionScriptManager.saveActionScript(commands);
    }

    private static String getActionScriptPath() {
        String systemPath = PathManager.getPluginTempPath();
        return systemPath + File.separator + ACTION_SCRIPT_FILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ActionCommand> loadActionScript() throws IOException {
        File file = new File(StartupActionScriptManager.getActionScriptPath());
        if (file.exists()) {
            boolean fileCorrupted = false;
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(new FileInputStream(file));
                List list = (List)ois.readObject();
                return list;
            }
            catch (Throwable e) {
                fileCorrupted = true;
                LOG.error("Internal file was corrupted. Problem is fixed.\nIf some plugins has been installed/uninstalled, please re-install/-uninstall them.", e);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                ArrayList<ActionCommand> arrayList = new ArrayList<ActionCommand>();
                return arrayList;
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                finally {
                    if (fileCorrupted) {
                        FileUtil.delete((File)file);
                    }
                }
            }
        }
        return new ArrayList<ActionCommand>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveActionScript(List<ActionCommand> commands) throws IOException {
        File temp = new File(PathManager.getPluginTempPath());
        boolean exists = true;
        if (!temp.exists()) {
            exists = temp.mkdirs();
        }
        if (exists) {
            File file = new File(StartupActionScriptManager.getActionScriptPath());
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file, false));
            try {
                oos.writeObject(commands);
            }
            finally {
                oos.close();
            }
        }
    }

    private static boolean canCreateFile(File file) {
        return FileUtilRt.ensureCanCreateFile((File)file);
    }

    public static class DeleteCommand
    implements Serializable,
    ActionCommand {
        @NonNls
        private static final String action = "delete";
        private final File mySource;

        public DeleteCommand(File source) {
            this.mySource = source;
        }

        public String toString() {
            return "delete[" + this.mySource.getAbsolutePath() + "]";
        }

        @Override
        public void execute() throws IOException {
            if (this.mySource != null && this.mySource.exists() && !FileUtilRt.delete((File)this.mySource)) {
                System.err.println("Action " + this + " failed.");
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), MessageFormat.format("<html>Cannot delete {0}<br>Please, check your access rights on folder <br>{1}", this.mySource.getAbsolutePath(), this.mySource.getAbsolutePath()), "Installing Plugin", 0);
            }
        }
    }

    public static class UnzipCommand
    implements Serializable,
    ActionCommand {
        @NonNls
        private static final String action = "unzip";
        private File mySource;
        private FilenameFilter myFilenameFilter;
        private File myDestination;

        public UnzipCommand(File source, File destination) {
            this(source, destination, null);
        }

        public UnzipCommand(File source, File destination, FilenameFilter filenameFilter) {
            this.myDestination = destination;
            this.mySource = source;
            this.myFilenameFilter = filenameFilter;
        }

        public String toString() {
            return "unzip[" + this.mySource.getAbsolutePath() + (this.myDestination == null ? "" : ", " + this.myDestination.getAbsolutePath()) + "]";
        }

        @Override
        public void execute() throws IOException {
            if (!this.mySource.exists()) {
                System.err.println("Source file " + this.mySource.getAbsolutePath() + " does not exist for action " + this);
            } else if (!StartupActionScriptManager.canCreateFile(this.myDestination)) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), MessageFormat.format("<html>Cannot unzip {0}<br>to<br>{1}<br>Please, check your access rights on folder <br>{2}", this.mySource.getAbsolutePath(), this.myDestination.getAbsolutePath(), this.myDestination), "Installing Plugin", 0);
            } else {
                try {
                    ZipUtil.extract((File)this.mySource, (File)this.myDestination, (FilenameFilter)this.myFilenameFilter);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), MessageFormat.format("<html>Failed to extract ZIP file {0}<br>to<br>{1}<br>You may need to re-download the plugin you tried to install.", this.mySource.getAbsolutePath(), this.myDestination.getAbsolutePath()), "Installing Plugin", 0);
                }
            }
        }
    }

    public static class CopyCommand
    implements Serializable,
    ActionCommand {
        @NonNls
        private static final String action = "copy";
        private final File mySource;
        private final File myDestination;

        public CopyCommand(File source, File destination) {
            this.myDestination = destination;
            this.mySource = source;
        }

        public String toString() {
            return "copy[" + this.mySource.getAbsolutePath() + (this.myDestination == null ? "" : ", " + this.myDestination.getAbsolutePath()) + "]";
        }

        @Override
        public void execute() throws IOException {
            File parentFile = this.myDestination.getParentFile();
            if (!parentFile.exists() && !this.myDestination.getParentFile().mkdirs()) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), MessageFormat.format("<html>Cannot create parent directory [{0}] of {1}<br>Please, check your access rights on folder <br>{2}", parentFile.getAbsolutePath(), this.myDestination.getAbsolutePath(), parentFile.getParent()), "Installing Plugin", 0);
            }
            if (!this.mySource.exists()) {
                System.err.println("Source file " + this.mySource.getAbsolutePath() + " does not exist for action " + this);
            } else if (!StartupActionScriptManager.canCreateFile(this.myDestination)) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), MessageFormat.format("<html>Cannot copy {0}<br>to<br>{1}<br>Please, check your access rights on folder <br>{2}", this.mySource.getAbsolutePath(), this.myDestination.getAbsolutePath(), this.myDestination.getParent()), "Installing Plugin", 0);
            } else {
                FileUtilRt.copy((File)this.mySource, (File)this.myDestination);
            }
        }
    }

    public static interface ActionCommand {
        public void execute() throws IOException;
    }
}

