/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertySuppressableInspectionBase;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;

public class TrailingSpacesInPropertyInspection
extends PropertySuppressableInspectionBase {
    public boolean myIgnoreVisibleSpaces;

    public String getDisplayName() {
        return PropertiesBundle.message("trail.spaces.property.inspection.display.name", new Object[0]);
    }

    public String getShortName() {
        return "TrailingSpacesInProperty";
    }

    public void writeSettings(Element node) throws WriteExternalException {
        if (this.myIgnoreVisibleSpaces) {
            node.setAttribute("ignoreVisibleSpaces", Boolean.TRUE.toString());
        }
    }

    public void readSettings(Element node) throws InvalidDataException {
        String attributeValue = node.getAttributeValue("ignoreVisibleSpaces");
        if (attributeValue != null) {
            this.myIgnoreVisibleSpaces = Boolean.valueOf(attributeValue);
        }
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(PropertiesBundle.message("trailing.spaces.in.property.inspection.ignore.visible.spaces", new Object[0]), (InspectionProfileEntry)this, "myIgnoreVisibleSpaces");
    }

    public ProblemDescriptor[] checkFile(PsiFile file, InspectionManager manager, boolean isOnTheFly) {
        if (!(file instanceof PropertiesFile)) {
            return null;
        }
        List<IProperty> properties = ((PropertiesFile)file).getProperties();
        SmartList descriptors = new SmartList();
        for (IProperty property : properties) {
            PsiElement value;
            TextRange textRange;
            ASTNode valueNode;
            PsiElement key;
            TextRange textRange2;
            ProgressManager.checkCanceled();
            ASTNode keyNode = ((PropertyImpl)property).getKeyNode();
            if (keyNode != null && (textRange2 = TrailingSpacesInPropertyInspection.getTrailingSpaces(key = keyNode.getPsi(), this.myIgnoreVisibleSpaces)) != null) {
                descriptors.add(manager.createProblemDescriptor(key, textRange2, "Trailing Spaces", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[]{new RemoveTrailingSpacesFix(this.myIgnoreVisibleSpaces)}));
            }
            if ((valueNode = ((PropertyImpl)property).getValueNode()) == null || (textRange = TrailingSpacesInPropertyInspection.getTrailingSpaces(value = valueNode.getPsi(), this.myIgnoreVisibleSpaces)) == null) continue;
            descriptors.add(manager.createProblemDescriptor(value, textRange, "Trailing Spaces", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[]{new RemoveTrailingSpacesFix(this.myIgnoreVisibleSpaces)}));
        }
        return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    private static TextRange getTrailingSpaces(PsiElement element, boolean ignoreVisibleTrailingSpaces) {
        String key = element.getText();
        if (ignoreVisibleTrailingSpaces) {
            for (int i = key.length() - 1; i > -1; --i) {
                if (key.charAt(i) == ' ' || key.charAt(i) == '\t') continue;
                return i == key.length() - 1 ? null : new TextRange(i + 1, key.length());
            }
            return element.getTextRange();
        }
        return PropertyImpl.trailingSpaces(key);
    }

    private static class RemoveTrailingSpacesFix
    implements LocalQuickFix {
        private final boolean myIgnoreVisibleSpaces;

        private RemoveTrailingSpacesFix(boolean ignoreVisibleSpaces) {
            this.myIgnoreVisibleSpaces = ignoreVisibleSpaces;
        }

        public String getName() {
            return "Remove Trailing Spaces";
        }

        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(Project project, ProblemDescriptor descriptor) {
            PsiElement parent;
            PsiElement element = descriptor.getPsiElement();
            PsiElement psiElement = parent = element == null ? null : element.getParent();
            if (!(parent instanceof PropertyImpl)) {
                return;
            }
            TextRange textRange = TrailingSpacesInPropertyInspection.getTrailingSpaces(element, this.myIgnoreVisibleSpaces);
            if (textRange != null) {
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(element.getContainingFile());
                TextRange docRange = textRange.shiftRight(element.getTextRange().getStartOffset());
                document.deleteString(docRange.getStartOffset(), docRange.getEndOffset());
            }
        }
    }
}

