/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.CustomResourceBundleState;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CustomResourceBundle
extends ResourceBundle {
    private static final Logger LOG = Logger.getInstance(CustomResourceBundle.class);
    private final List<PropertiesFile> myFiles;
    private final String myBaseName;

    private CustomResourceBundle(List<PropertiesFile> files, String baseName) {
        LOG.assertTrue(!files.isEmpty());
        this.myFiles = new ArrayList<PropertiesFile>(files);
        Collections.sort(this.myFiles, new Comparator<PropertiesFile>(){

            @Override
            public int compare(PropertiesFile f1, PropertiesFile f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        this.myBaseName = baseName;
    }

    public static CustomResourceBundle fromState(CustomResourceBundleState state, Project project) {
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        List files = ContainerUtil.map(state.getFiles(VirtualFileManager.getInstance()), (Function)new Function<VirtualFile, PropertiesFile>(){

            public PropertiesFile fun(VirtualFile virtualFile) {
                return PropertiesImplUtil.getPropertiesFile(psiManager.findFile(virtualFile));
            }
        });
        return files.size() < 2 ? null : new CustomResourceBundle(files, state.getBaseName());
    }

    @Override
    public List<PropertiesFile> getPropertiesFiles() {
        return this.myFiles;
    }

    @Override
    public PropertiesFile getDefaultPropertiesFile() {
        return (PropertiesFile)ContainerUtil.getFirstItem(this.myFiles);
    }

    @Override
    public String getBaseName() {
        return this.myBaseName;
    }

    @Override
    public VirtualFile getBaseDirectory() {
        return null;
    }

    @Override
    public Project getProject() {
        return this.getDefaultPropertiesFile().getProject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomResourceBundle resourceBundle = (CustomResourceBundle)o;
        return ((Object)resourceBundle.getPropertiesFiles()).equals(resourceBundle.getPropertiesFiles()) && resourceBundle.getBaseName().equals(this.getBaseName());
    }

    public int hashCode() {
        return ((Object)this.myFiles).hashCode() * 31 + this.myBaseName.hashCode();
    }
}

