/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;

public class PropertiesFilesManager
extends AbstractProjectComponent {
    public static PropertiesFilesManager getInstance(Project project) {
        return (PropertiesFilesManager)((Object)project.getComponent(PropertiesFilesManager.class));
    }

    public PropertiesFilesManager(Project project) {
        super(project);
    }

    public void projectOpened() {
        PropertyChangeListener myListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("native2ascii".equals(propertyName) || "propertiesFilesEncoding".equals(propertyName)) {
                    DumbService.getInstance((Project)PropertiesFilesManager.this.myProject).smartInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    Collection filesToRefresh = FileBasedIndex.getInstance().getContainingFiles(FileTypeIndex.NAME, (Object)PropertiesFileType.INSTANCE, GlobalSearchScope.allScope((Project)PropertiesFilesManager.this.myProject));
                                    VirtualFile[] virtualFiles = VfsUtilCore.toVirtualFileArray((Collection)filesToRefresh);
                                    FileDocumentManager.getInstance().saveAllDocuments();
                                    for (VirtualFile virtualFile : virtualFiles) {
                                        virtualFile.setCharset(null);
                                    }
                                    FileDocumentManager.getInstance().reloadFiles(virtualFiles);
                                }
                            });
                        }
                    });
                }
            }
        };
        EncodingManager.getInstance().addPropertyChangeListener(myListener, (Disposable)this.myProject);
    }

    public String getComponentName() {
        return "PropertiesFileManager";
    }
}

