/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.xml.XmlPropertiesIndex;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PropertiesReferenceManager {
    private final PsiManager myPsiManager;
    private final DumbService myDumbService;

    public static PropertiesReferenceManager getInstance(Project project) {
        return (PropertiesReferenceManager)ServiceManager.getService((Project)project, PropertiesReferenceManager.class);
    }

    public PropertiesReferenceManager(PsiManager psiManager, DumbService dumbService) {
        this.myPsiManager = psiManager;
        this.myDumbService = dumbService;
    }

    public List<PropertiesFile> findPropertiesFiles(final Module module, String bundleName) {
        ConcurrentFactoryMap map = (ConcurrentFactoryMap)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<ConcurrentFactoryMap<String, List<PropertiesFile>>>(){

            public CachedValueProvider.Result<ConcurrentFactoryMap<String, List<PropertiesFile>>> compute() {
                ConcurrentFactoryMap<String, List<PropertiesFile>> factoryMap = new ConcurrentFactoryMap<String, List<PropertiesFile>>(){

                    protected List<PropertiesFile> create(String bundleName) {
                        return PropertiesReferenceManager.this.findPropertiesFiles(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module), bundleName, BundleNameEvaluator.DEFAULT);
                    }
                };
                return CachedValueProvider.Result.create((Object)factoryMap, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
        return (List)map.get((Object)bundleName);
    }

    public List<PropertiesFile> findPropertiesFiles(GlobalSearchScope searchScope, final String bundleName, BundleNameEvaluator bundleNameEvaluator) {
        final ArrayList<PropertiesFile> result = new ArrayList<PropertiesFile>();
        this.processPropertiesFiles(searchScope, new PropertiesFileProcessor(){

            @Override
            public boolean process(String baseName, PropertiesFile propertiesFile) {
                if (baseName.equals(bundleName)) {
                    result.add(propertiesFile);
                }
                return true;
            }
        }, bundleNameEvaluator);
        return result;
    }

    public PropertiesFile findPropertiesFile(Module module, String bundleName, Locale locale) {
        List<PropertiesFile> propFiles = this.findPropertiesFiles(module, bundleName);
        if (locale != null) {
            for (PropertiesFile propFile : propFiles) {
                if (!propFile.getLocale().equals(locale)) continue;
                return propFile;
            }
        }
        for (PropertiesFile propFile : propFiles) {
            if (propFile.getLocale().getLanguage().length() != 0 && !propFile.getLocale().equals(Locale.getDefault())) continue;
            return propFile;
        }
        if (!propFiles.isEmpty()) {
            return propFiles.get(0);
        }
        return null;
    }

    public String[] getPropertyFileBaseNames(GlobalSearchScope searchScope, BundleNameEvaluator bundleNameEvaluator) {
        final ArrayList result = new ArrayList();
        this.processPropertiesFiles(searchScope, new PropertiesFileProcessor(){

            @Override
            public boolean process(String baseName, PropertiesFile propertiesFile) {
                result.add(baseName);
                return true;
            }
        }, bundleNameEvaluator);
        return ArrayUtil.toStringArray(result);
    }

    public boolean processAllPropertiesFiles(PropertiesFileProcessor processor) {
        return this.processPropertiesFiles(GlobalSearchScope.allScope((Project)this.myPsiManager.getProject()), processor, BundleNameEvaluator.DEFAULT);
    }

    public boolean processPropertiesFiles(GlobalSearchScope searchScope, final PropertiesFileProcessor processor, final BundleNameEvaluator evaluator) {
        boolean result = FileBasedIndex.getInstance().processValues(FileTypeIndex.NAME, (Object)PropertiesFileType.INSTANCE, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Void>(){

            public boolean process(VirtualFile file, Void value) {
                return PropertiesReferenceManager.this.processFile(file, evaluator, processor);
            }
        }, searchScope);
        if (!result) {
            return false;
        }
        return this.myDumbService.isDumb() || FileBasedIndex.getInstance().processValues(XmlPropertiesIndex.NAME, (Object)XmlPropertiesIndex.MARKER_KEY, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<String>(){

            public boolean process(VirtualFile file, String value) {
                return PropertiesReferenceManager.this.processFile(file, evaluator, processor);
            }
        }, searchScope);
    }

    private boolean processFile(VirtualFile file, BundleNameEvaluator evaluator, PropertiesFileProcessor processor) {
        String qName;
        PsiFile psiFile = this.myPsiManager.findFile(file);
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(psiFile);
        return propertiesFile == null || (qName = evaluator.evaluateBundleName(psiFile)) == null || processor.process(qName, propertiesFile);
    }
}

