/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesList;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;

public abstract class PropertySuppressableInspectionBase
extends LocalInspectionTool
implements CustomSuppressableInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.properties.PropertySuppressableInspectionBase");

    public String getGroupDisplayName() {
        return PropertiesBundle.message("properties.files.inspection.group.display.name", new Object[0]);
    }

    public SuppressIntentionAction[] getSuppressActions(PsiElement element) {
        return new SuppressIntentionAction[]{new SuppressSinglePropertyFix(this.getShortName()), new SuppressForFile(this.getShortName())};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSuppressedFor(PsiElement element) {
        String text;
        PropertiesFile file;
        Property property = (Property)PsiTreeUtil.getParentOfType((PsiElement)element, Property.class, (boolean)false);
        if (property == null) {
            PsiFile containingFile = element.getContainingFile();
            if (!(containingFile instanceof PropertiesFile)) return false;
            file = (PropertiesFile)containingFile;
        } else {
            PsiElement prev = property.getPrevSibling();
            while (prev instanceof PsiWhiteSpace || prev instanceof PsiComment) {
                if (prev instanceof PsiComment && (text = prev.getText()).contains("suppress") && text.contains("\"" + this.getShortName() + "\"")) {
                    return true;
                }
                prev = prev.getPrevSibling();
            }
            file = property.getPropertiesFile();
        }
        PsiElement leaf = file.getContainingFile().findElementAt(0);
        while (leaf instanceof PsiWhiteSpace) {
            leaf = leaf.getNextSibling();
        }
        while (leaf instanceof PsiComment) {
            text = leaf.getText();
            if (text.contains("suppress") && text.contains("\"" + this.getShortName() + "\"") && text.contains("file")) {
                return true;
            }
            if ((leaf = leaf.getNextSibling()) instanceof PsiWhiteSpace) {
                leaf = leaf.getNextSibling();
            }
            if (!(leaf instanceof PropertiesList) || leaf.getFirstChild() != property || !text.contains("suppress") || !text.contains("\"" + this.getShortName() + "\"")) continue;
            return true;
        }
        return false;
    }

    private static class SuppressForFile
    extends SuppressIntentionAction {
        private final String shortName;

        public SuppressForFile(String shortName) {
            this.shortName = shortName;
        }

        public String getText() {
            return PropertiesBundle.message("unused.property.suppress.for.file", new Object[0]);
        }

        public String getFamilyName() {
            return PropertiesBundle.message("unused.property.suppress.for.file", new Object[0]);
        }

        public boolean isAvailable(Project project, Editor editor, PsiElement element) {
            return element.isValid() && element.getContainingFile() instanceof PropertiesFile;
        }

        public void invoke(Project project, Editor editor, PsiElement element) throws IncorrectOperationException {
            PsiFile file = element.getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            LOG.assertTrue(doc != null, (Object)file);
            doc.insertString(0, (CharSequence)("# suppress inspection \"" + this.shortName + "\" for whole file\n"));
        }
    }

    private static class SuppressSinglePropertyFix
    extends SuppressIntentionAction {
        private final String shortName;

        public SuppressSinglePropertyFix(String shortName) {
            this.shortName = shortName;
        }

        public String getText() {
            return PropertiesBundle.message("unused.property.suppress.for.property", new Object[0]);
        }

        public String getFamilyName() {
            return PropertiesBundle.message("unused.property.suppress.for.property", new Object[0]);
        }

        public boolean isAvailable(Project project, Editor editor, PsiElement element) {
            Property property = (Property)PsiTreeUtil.getParentOfType((PsiElement)element, Property.class);
            return property != null && property.isValid();
        }

        public void invoke(Project project, Editor editor, PsiElement element) throws IncorrectOperationException {
            PsiFile file = element.getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            Property property = (Property)PsiTreeUtil.getParentOfType((PsiElement)element, Property.class);
            LOG.assertTrue(property != null);
            int start = property.getTextRange().getStartOffset();
            Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            LOG.assertTrue(doc != null);
            int line = doc.getLineNumber(start);
            int lineStart = doc.getLineStartOffset(line);
            doc.insertString(lineStart, (CharSequence)("# suppress inspection \"" + this.shortName + "\"\n"));
        }
    }
}

