/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GotoResourceBundleLocalizationsProvider
extends GotoRelatedProvider {
    public List<? extends GotoRelatedItem> getItems(DataContext context) {
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context);
        if (editor instanceof ResourceBundleEditor) {
            return Collections.emptyList();
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (psiFile == null || !(psiFile instanceof PropertiesFile)) {
            return Collections.emptyList();
        }
        ResourceBundle resourceBundle = ((PropertiesFile)psiFile).getResourceBundle();
        List<PropertiesFile> bundlePropertiesFiles = resourceBundle.getPropertiesFiles(((PropertiesFile)psiFile).getProject());
        assert (bundlePropertiesFiles.size() != 0);
        if (bundlePropertiesFiles.size() != 1) {
            ArrayList propertiesFilesWithoutCurrent = ContainerUtil.newArrayList(bundlePropertiesFiles);
            propertiesFilesWithoutCurrent.remove(psiFile);
            return ContainerUtil.map((Collection)propertiesFilesWithoutCurrent, (Function)new Function<PropertiesFile, GotoRelatedItem>(){

                public GotoRelatedItem fun(PropertiesFile propertiesFile) {
                    return new GotoRelatedItem((PsiElement)propertiesFile, "Other Localizations");
                }
            });
        }
        return Collections.emptyList();
    }
}

