/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class ResourceBundleFileStructureViewElement
implements StructureViewTreeElement,
ResourceBundleEditorViewElement {
    private final ResourceBundle myResourceBundle;

    public ResourceBundleFileStructureViewElement(ResourceBundle resourceBundle) {
        this.myResourceBundle = resourceBundle;
    }

    public ResourceBundle getValue() {
        return this.myResourceBundle;
    }

    public StructureViewTreeElement[] getChildren() {
        List<PropertiesFile> propertiesFiles = this.myResourceBundle.getPropertiesFiles();
        LinkedHashMap<String, IProperty> propertyNames = new LinkedHashMap<String, IProperty>();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            List<IProperty> properties = propertiesFile.getProperties();
            for (IProperty property : properties) {
                String name = property.getKey();
                if (propertyNames.containsKey(name)) continue;
                propertyNames.put(name, property);
            }
        }
        ArrayList<ResourceBundlePropertyStructureViewElement> result = new ArrayList<ResourceBundlePropertyStructureViewElement>(propertyNames.size());
        for (Map.Entry propertyEntry : propertyNames.entrySet()) {
            result.add(new ResourceBundlePropertyStructureViewElement(this.myResourceBundle, (IProperty)propertyEntry.getValue()));
        }
        return result.toArray(new StructureViewTreeElement[result.size()]);
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return ResourceBundleFileStructureViewElement.this.myResourceBundle.getBaseName();
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return AllIcons.FileTypes.Properties;
            }
        };
    }

    @Override
    public PsiElement[] getPsiElements() {
        List<PropertiesFile> propertiesFiles = this.getValue().getPropertiesFiles();
        return (PsiElement[])ContainerUtil.map2Array(propertiesFiles, (Object[])new PsiElement[propertiesFiles.size()], (Function)new Function<PropertiesFile, PsiElement>(){

            public PsiElement fun(PropertiesFile propertiesFile) {
                return propertiesFile.getContainingFile();
            }
        });
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }
}

