/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesResourceBundleUtil;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFileFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;

public class PropertiesElementFactory {
    private static final UserDataCache<PropertiesFile, Project, Void> PROPERTIES = new UserDataCache<PropertiesFile, Project, Void>("system.properties.file"){

        protected PropertiesFile compute(Project project, Void p) {
            return PropertiesElementFactory.createPropertiesFile(project, System.getProperties(), "system");
        }
    };

    public static IProperty createProperty(Project project, @NonNls String name, @NonNls String value) {
        String text = PropertiesElementFactory.getPropertyText(name, value, null, project);
        PropertiesFile dummyFile = PropertiesElementFactory.createPropertiesFile(project, text);
        return dummyFile.getProperties().get(0);
    }

    public static String getPropertyText(@NonNls String name, @NonNls String value, @NonNls Character delimiter, Project project) {
        if (delimiter == null) {
            delimiter = Character.valueOf(project == null ? (char)'=' : PropertiesCodeStyleSettings.getInstance((Project)project).KEY_VALUE_DELIMITER);
        }
        return PropertiesElementFactory.escape(name) + String.valueOf(delimiter) + PropertiesElementFactory.escapeValue(value);
    }

    public static PropertiesFile createPropertiesFile(Project project, @NonNls String text) {
        String filename = "dummy." + PropertiesFileType.INSTANCE.getDefaultExtension();
        return (PropertiesFile)PsiFileFactory.getInstance((Project)project).createFileFromText(filename, (FileType)PropertiesFileType.INSTANCE, (CharSequence)text);
    }

    public static PropertiesFile createPropertiesFile(Project project, Properties properties, String fileName) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            properties.store(stream, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String filename = fileName + "." + PropertiesFileType.INSTANCE.getDefaultExtension();
        return (PropertiesFile)PsiFileFactory.getInstance((Project)project).createFileFromText(filename, (FileType)PropertiesFileType.INSTANCE, (CharSequence)stream.toString());
    }

    public static PropertiesFile getSystemProperties(Project project) {
        return (PropertiesFile)PROPERTIES.get((UserDataHolder)project, null);
    }

    private static String escape(String name) {
        if (StringUtil.startsWithChar((CharSequence)name, (char)'#')) {
            name = PropertiesElementFactory.escapeChar(name, '#');
        }
        if (StringUtil.startsWithChar((CharSequence)name, (char)'!')) {
            name = PropertiesElementFactory.escapeChar(name, '!');
        }
        name = PropertiesElementFactory.escapeChar(name, '=');
        name = PropertiesElementFactory.escapeChar(name, ':');
        name = PropertiesElementFactory.escapeChar(name, ' ');
        name = PropertiesElementFactory.escapeChar(name, '\t');
        return name;
    }

    private static String escapeChar(String name, char c) {
        int offset = 0;
        int i;
        while ((i = name.indexOf(c, offset)) != -1) {
            if (i == 0 || name.charAt(i - 1) != '\\') {
                name = name.substring(0, i) + '\\' + name.substring(i);
            }
            offset = i + 2;
        }
        return name;
    }

    public static String escapeValue(String value) {
        return PropertiesResourceBundleUtil.fromValueEditorToPropertyValue(value);
    }
}

