/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class PropertiesFileImpl
extends PsiFileBase
implements PropertiesFile {
    private static final Logger LOG = Logger.getInstance(PropertiesFileImpl.class);
    private static final TokenSet PROPERTIES_LIST_SET = TokenSet.create((IElementType[])new IElementType[]{PropertiesElementTypes.PROPERTIES_LIST});
    private volatile MostlySingularMultiMap<String, IProperty> myPropertiesMap;
    private volatile List<IProperty> myProperties;
    private volatile boolean myAlphaSorted;
    private final Object lock = new Object();

    public PropertiesFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, (Language)PropertiesLanguage.INSTANCE);
    }

    public FileType getFileType() {
        return PropertiesFileType.INSTANCE;
    }

    @NonNls
    public String toString() {
        return "Properties file:" + this.getName();
    }

    @Override
    public List<IProperty> getProperties() {
        this.ensurePropertiesLoaded();
        return this.myProperties;
    }

    private ASTNode getPropertiesList() {
        return (ASTNode)ArrayUtil.getFirstElement((Object[])this.getNode().getChildren(PROPERTIES_LIST_SET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensurePropertiesLoaded() {
        if (this.myPropertiesMap != null) {
            return;
        }
        ASTNode[] props = this.getPropertiesList().getChildren(PropertiesElementTypes.PROPERTIES);
        MostlySingularMultiMap propertiesMap = new MostlySingularMultiMap();
        ArrayList<IProperty> properties = new ArrayList<IProperty>(props.length);
        for (ASTNode prop : props) {
            Property property = (Property)prop.getPsi();
            String key = property.getUnescapedKey();
            propertiesMap.add((Object)key, (Object)property);
            properties.add(property);
        }
        boolean isAlphaSorted = PropertiesImplUtil.isAlphaSorted(properties);
        Object object = this.lock;
        synchronized (object) {
            if (this.myPropertiesMap != null) {
                return;
            }
            this.myProperties = properties;
            this.myPropertiesMap = propertiesMap;
            this.myAlphaSorted = isAlphaSorted;
        }
    }

    public Character findFirstKeyValueDelimiter() {
        for (IProperty property : this.myProperties) {
            Character separator = ((PropertyImpl)property).getKeyValueDelimiter();
            if (separator == null) continue;
            return separator;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProperty findPropertyByKey(String key) {
        this.ensurePropertiesLoaded();
        Object object = this.lock;
        synchronized (object) {
            Iterator iterator = this.myPropertiesMap.get((Object)key).iterator();
            return iterator.hasNext() ? (IProperty)iterator.next() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IProperty> findPropertiesByKey(String key) {
        this.ensurePropertiesLoaded();
        Object object = this.lock;
        synchronized (object) {
            return ContainerUtil.collect(this.myPropertiesMap.get((Object)key).iterator());
        }
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return PropertiesImplUtil.getResourceBundle(this);
    }

    @Override
    public Locale getLocale() {
        return ResourceBundleManager.getInstance(this.getProject()).getLocale(this.getVirtualFile());
    }

    public PsiElement add(PsiElement element) throws IncorrectOperationException {
        if (element instanceof Property) {
            throw new IncorrectOperationException("Use addProperty() instead");
        }
        return super.add(element);
    }

    @Override
    public PsiElement addProperty(IProperty property) throws IncorrectOperationException {
        IProperty position = this.findInsertionPosition(property);
        return this.addPropertyAfter((Property)property, (Property)position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProperty findInsertionPosition(IProperty property) {
        Object object = this.lock;
        synchronized (object) {
            this.ensurePropertiesLoaded();
            if (this.myProperties.isEmpty()) {
                return null;
            }
            if (this.myAlphaSorted) {
                int insertIndex = Collections.binarySearch(this.myProperties, property, new Comparator<IProperty>(){

                    @Override
                    public int compare(IProperty p1, IProperty p2) {
                        String k1 = p1.getKey();
                        String k2 = p2.getKey();
                        LOG.assertTrue(k1 != null && k2 != null);
                        return k1.compareTo(k2);
                    }
                });
                IProperty iProperty = insertIndex == -1 ? null : this.myProperties.get(insertIndex < 0 ? -insertIndex - 2 : insertIndex);
                return iProperty;
            }
            return this.myProperties.get(this.myProperties.size() - 1);
        }
    }

    @Override
    public PsiElement addPropertyAfter(Property property, Property anchor) throws IncorrectOperationException {
        ASTNode anchorBefore;
        TreeElement copy = ChangeUtil.copyToElement((PsiElement)property);
        List<IProperty> properties = this.getProperties();
        Object object = anchor == null ? (properties.isEmpty() ? null : properties.get(0).getPsiElement().getNode()) : (anchorBefore = anchor.getNode().getTreeNext());
        if (anchorBefore != null && anchorBefore.getElementType() == TokenType.WHITE_SPACE) {
            anchorBefore = anchorBefore.getTreeNext();
        }
        if (anchorBefore == null && this.haveToAddNewLine()) {
            this.insertLineBreakBefore(null);
        }
        this.getPropertiesList().addChild((ASTNode)copy, anchorBefore);
        if (anchorBefore != null) {
            this.insertLineBreakBefore(anchorBefore);
        }
        return copy.getPsi();
    }

    @Override
    public IProperty addProperty(String key, String value) {
        return (IProperty)this.addProperty(PropertiesElementFactory.createProperty(this.getProject(), key, value));
    }

    @Override
    public IProperty addPropertyAfter(String key, String value, Property anchor) {
        return (IProperty)this.addPropertyAfter((Property)PropertiesElementFactory.createProperty(this.getProject(), key, value), anchor);
    }

    private void insertLineBreakBefore(ASTNode anchorBefore) {
        this.getPropertiesList().addChild((ASTNode)ASTFactory.whitespace((CharSequence)"\n"), anchorBefore);
    }

    private boolean haveToAddNewLine() {
        ASTNode lastChild = this.getPropertiesList().getLastChildNode();
        return lastChild != null && !lastChild.getText().endsWith("\n");
    }

    @Override
    public Map<String, String> getNamesMap() {
        THashMap result = new THashMap();
        for (IProperty property : this.getProperties()) {
            result.put(property.getUnescapedKey(), property.getValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAlphaSorted() {
        Object object = this.lock;
        synchronized (object) {
            this.ensurePropertiesLoaded();
            return this.myAlphaSorted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        super.clearCaches();
        Object object = this.lock;
        synchronized (object) {
            this.myPropertiesMap = null;
            this.myProperties = null;
        }
    }
}

