/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.refactoring.rename;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.refactoring.PropertiesRefactoringSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.usageView.UsageInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RenamePropertyProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(PsiElement element) {
        return element instanceof IProperty;
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        Project project = element.getProject();
        ResourceBundle resourceBundle = ((IProperty)element).getPropertiesFile().getResourceBundle();
        LinkedHashMap<PsiElement, String> allRenamesCopy = new LinkedHashMap<PsiElement, String>(allRenames);
        allRenames.clear();
        for (Map.Entry e : allRenamesCopy.entrySet()) {
            IProperty property = (IProperty)e.getKey();
            List<IProperty> properties = PropertiesUtil.findAllProperties(resourceBundle, property.getUnescapedKey());
            for (IProperty toRename : properties) {
                allRenames.put(toRename.getPsiElement(), (String)e.getValue());
            }
        }
    }

    public void findCollisions(PsiElement element, String newName, Map<? extends PsiElement, String> allRenames, List<UsageInfo> result) {
        for (final Map.Entry<? extends PsiElement, String> e : allRenames.entrySet()) {
            for (IProperty property : ((PropertiesFile)e.getKey().getContainingFile()).getProperties()) {
                if (!Comparing.strEqual((String)e.getValue(), (String)property.getKey())) continue;
                result.add((UsageInfo)new UnresolvableCollisionUsageInfo(property.getPsiElement(), e.getKey()){

                    public String getDescription() {
                        return "New property name '" + (String)e.getValue() + "' hides existing property";
                    }
                });
            }
        }
    }

    public boolean isToSearchInComments(PsiElement element) {
        return PropertiesRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        PropertiesRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS = enabled;
    }
}

