/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.properties.editor.PropertiesGroupingStructureViewModel;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.structureView.GroupByWordPrefixes;
import com.intellij.lang.properties.structureView.PropertiesFileStructureViewElement;
import com.intellij.lang.properties.structureView.PropertiesPrefixGroup;
import com.intellij.lang.properties.structureView.PropertiesSeparatorManager;
import com.intellij.psi.PsiFile;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;

public class PropertiesFileStructureViewModel
extends TextEditorBasedStructureViewModel
implements PropertiesGroupingStructureViewModel {
    private final PropertiesFileImpl myPropertiesFile;
    private final GroupByWordPrefixes myByWordPrefixesGrouper;
    @NonNls
    public static final String KIND_SORTER_ID = "KIND_SORTER";
    private static final Sorter KIND_SORTER = new Sorter(){

        public Comparator getComparator() {
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    int weight1 = o1 instanceof PropertiesPrefixGroup ? 1 : 0;
                    int weight2 = o2 instanceof PropertiesPrefixGroup ? 1 : 0;
                    return weight1 - weight2;
                }
            };
        }

        public boolean isVisible() {
            return true;
        }

        public ActionPresentation getPresentation() {
            String name = IdeBundle.message((String)"action.sort.by.type", (Object[])new Object[0]);
            return new ActionPresentationData(name, name, AllIcons.ObjectBrowser.SortByType);
        }

        public String getName() {
            return PropertiesFileStructureViewModel.KIND_SORTER_ID;
        }
    };

    public PropertiesFileStructureViewModel(PropertiesFileImpl root) {
        super((PsiFile)root);
        this.myPropertiesFile = root;
        String separator = PropertiesSeparatorManager.getInstance(root.getProject()).getSeparator(root.getResourceBundle());
        this.myByWordPrefixesGrouper = new GroupByWordPrefixes(separator);
    }

    @Override
    public void setSeparator(String separator) {
        this.myByWordPrefixesGrouper.setSeparator(separator);
        PropertiesSeparatorManager.getInstance(this.myPropertiesFile.getProject()).setSeparator(this.myPropertiesFile.getResourceBundle(), separator);
    }

    @Override
    public String getSeparator() {
        return this.myByWordPrefixesGrouper.getSeparator();
    }

    public StructureViewTreeElement getRoot() {
        return new PropertiesFileStructureViewElement(this.myPropertiesFile);
    }

    public Grouper[] getGroupers() {
        return new Grouper[]{this.myByWordPrefixesGrouper};
    }

    public Sorter[] getSorters() {
        return new Sorter[]{Sorter.ALPHA_SORTER, KIND_SORTER};
    }

    protected PsiFile getPsiFile() {
        return this.myPropertiesFile;
    }

    protected Class[] getSuitableClasses() {
        return new Class[]{Property.class};
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return false;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        return false;
    }
}

