/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.structureView.PropertiesStructureViewElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;

public class PropertiesPrefixGroup
implements Group,
ResourceBundleEditorViewElement {
    private final Collection<TreeElement> myProperties;
    private final String myPrefix;
    private final String myPresentableName;
    private final String mySeparator;

    public PropertiesPrefixGroup(Collection<TreeElement> properties, String prefix, String presentableName, String separator) {
        this.myProperties = properties;
        this.myPrefix = prefix;
        this.myPresentableName = presentableName;
        this.mySeparator = separator;
    }

    public String getPresentableName() {
        return this.myPresentableName;
    }

    public String getSeparator() {
        return this.mySeparator;
    }

    public String getPrefix() {
        return this.myPrefix;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return PropertiesPrefixGroup.this.myPresentableName;
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return AllIcons.Nodes.Advice;
            }
        };
    }

    public Collection<TreeElement> getChildren() {
        ArrayList<TreeElement> result = new ArrayList<TreeElement>();
        List prefixWords = StringUtil.split((String)this.myPrefix, (String)this.mySeparator);
        for (TreeElement treeElement : this.myProperties) {
            boolean startsWith;
            String key;
            Object value;
            if (!(treeElement instanceof StructureViewTreeElement) || !((value = ((StructureViewTreeElement)treeElement).getValue()) instanceof IProperty) || (key = ((IProperty)value).getUnescapedKey()) == null) continue;
            if (!key.equals(this.myPrefix)) {
                List keyWords = StringUtil.split((String)key, (String)this.mySeparator);
                boolean bl = startsWith = prefixWords.size() < keyWords.size();
                if (startsWith) {
                    for (int i = 0; i < prefixWords.size(); ++i) {
                        String prefixWord = (String)prefixWords.get(i);
                        String keyWord = (String)keyWords.get(i);
                        if (Comparing.strEqual((String)keyWord, (String)prefixWord)) continue;
                        startsWith = false;
                        break;
                    }
                }
            } else {
                startsWith = true;
            }
            if (!startsWith) continue;
            result.add(treeElement);
            String presentableName = key.substring(this.myPrefix.length());
            presentableName = StringUtil.trimStart((String)presentableName, (String)this.mySeparator);
            if (treeElement instanceof PropertiesStructureViewElement) {
                ((PropertiesStructureViewElement)treeElement).setPresentableName(presentableName);
            }
            if (!(treeElement instanceof ResourceBundlePropertyStructureViewElement)) continue;
            ((ResourceBundlePropertyStructureViewElement)treeElement).setPresentableName(presentableName);
        }
        return result;
    }

    @Override
    public PsiElement[] getPsiElements() {
        List elements = ContainerUtil.mapNotNull(this.getChildren(), (Function)new NullableFunction<TreeElement, PsiElement>(){

            public PsiElement fun(TreeElement treeElement) {
                if (treeElement instanceof PropertiesStructureViewElement) {
                    PropertiesStructureViewElement propertiesElement = (PropertiesStructureViewElement)treeElement;
                    Property property = propertiesElement.getValue();
                    return property.getPsiElement();
                }
                if (treeElement instanceof ResourceBundlePropertyStructureViewElement) {
                    return ((ResourceBundlePropertyStructureViewElement)treeElement).getPsiElements()[0];
                }
                return null;
            }
        });
        return elements.toArray(new PsiElement[elements.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertiesPrefixGroup group = (PropertiesPrefixGroup)o;
        return this.myPrefix.equals(group.myPrefix);
    }

    public int hashCode() {
        return this.myPrefix.hashCode();
    }
}

