/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.psi.Property;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;

public class PropertiesStructureViewElement
implements StructureViewTreeElement,
ResourceBundleEditorViewElement {
    private final Property myProperty;
    private String myPresentableName;
    private static final TextAttributesKey GROUP_KEY;

    public PropertiesStructureViewElement(Property element) {
        this.myProperty = element;
    }

    public Property getValue() {
        return this.myProperty;
    }

    public void navigate(boolean requestFocus) {
        this.myProperty.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myProperty.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myProperty.canNavigateToSource();
    }

    public StructureViewTreeElement[] getChildren() {
        return EMPTY_ARRAY;
    }

    @Override
    public PsiElement[] getPsiElements() {
        return new PsiElement[]{this.getValue()};
    }

    public ItemPresentation getPresentation() {
        return new ColoredItemPresentation(){

            public TextAttributesKey getTextAttributesKey() {
                return PropertiesStructureViewElement.this.myPresentableName != null && PropertiesStructureViewElement.this.myPresentableName.isEmpty() ? GROUP_KEY : null;
            }

            public String getPresentableText() {
                return PropertiesStructureViewElement.this.myPresentableName == null ? PropertiesStructureViewElement.this.myProperty.getUnescapedKey() : (PropertiesStructureViewElement.this.myPresentableName.isEmpty() ? "<property>" : PropertiesStructureViewElement.this.myPresentableName);
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return PropertiesStructureViewElement.this.myProperty.getIcon(0);
            }
        };
    }

    public void setPresentableName(String presentableName) {
        this.myPresentableName = presentableName;
    }

    static {
        TextAttributes attributes = new TextAttributes();
        attributes.setFontType(2);
        GROUP_KEY = TextAttributesKey.createTextAttributesKey((String)"STRUCTURE_GROUP_KEY", (TextAttributes)attributes);
    }
}

