/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.api.example;

import com.android.jill.api.ConfigNotSupportedException;
import com.android.jill.api.JillConfig;
import com.android.jill.api.JillProvider;
import com.android.jill.api.v01.Api01Config;
import com.android.jill.api.v01.Api01TranslationTask;
import com.android.jill.api.v01.ConfigurationException;
import com.android.jill.api.v01.TranslationException;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;

public class WithServiceLoader {
    public static void main(String[] args) throws SecurityException, IllegalArgumentException {
        Api01TranslationTask translationTask;
        Api01Config api01Config;
        JillProvider provider;
        if (args.length != 2) {
            System.out.println("Usage: <jill input archive> <jill output archive>");
            return;
        }
        ServiceLoader<JillProvider> serviceLoader = ServiceLoader.load(JillProvider.class);
        try {
            provider = serviceLoader.iterator().next();
        }
        catch (NoSuchElementException e) {
            System.out.println("Check that jill.jar is on classpath");
            return;
        }
        String string = String.valueOf(provider.getTranslatorVersion());
        System.out.println(string.length() != 0 ? "Translator version: ".concat(string) : new String("Translator version: "));
        String string2 = String.valueOf(provider.getTranslatorReleaseName());
        System.out.println(string2.length() != 0 ? "Translator release name: ".concat(string2) : new String("Translator release name: "));
        int n = provider.getTranslatorReleaseCode();
        System.out.println(new StringBuilder(36).append("Translator release code: ").append(n).toString());
        String string3 = String.valueOf(String.valueOf((Object)provider.getTranslatorSubReleaseKind()));
        System.out.println(new StringBuilder(29 + string3.length()).append("Translator sub-release kind: ").append(string3).toString());
        int n2 = provider.getTranslatorSubReleaseCode();
        System.out.println(new StringBuilder(40).append("Translator sub-release code: ").append(n2).toString());
        String str = provider.getTranslatorBuildId();
        String string4 = String.valueOf(str != null ? str : "Unknown");
        System.out.println(string4.length() != 0 ? "Translator build id: ".concat(string4) : new String("Translator build id: "));
        str = provider.getTranslatorSourceCodeBase();
        String string5 = String.valueOf(str != null ? str : "Unknown");
        System.out.println(string5.length() != 0 ? "Translator souce code base: ".concat(string5) : new String("Translator souce code base: "));
        System.out.print("Supported configurations: ");
        for (Class<? extends JillConfig> clazz : provider.getSupportedConfigs()) {
            System.out.print(clazz.getSimpleName());
            assert (provider.isConfigSupported(clazz));
        }
        System.out.println();
        try {
            api01Config = provider.createConfig(Api01Config.class);
        }
        catch (ConfigNotSupportedException e1) {
            System.err.println("Brest config not supported)");
            return;
        }
        try {
            api01Config.setInputJavaBinaryFile(new File(args[0]));
            api01Config.setOutputJackFile(new File(args[1]));
            translationTask = api01Config.getTask();
        }
        catch (ConfigurationException e) {
            System.err.println(e.getMessage());
            return;
        }
        try {
            translationTask.run();
        }
        catch (TranslationException e) {
            System.out.println("User error, see reporter");
            return;
        }
    }
}

